/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.temporal.TemporalQueries;
import org.exparity.hamcrest.date.core.TemporalAdapter;
import org.exparity.hamcrest.date.core.TemporalFormatter;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsLeapYear<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final TemporalAdapter<T> adapter;
    private final TemporalFormatter<T> formatter;

    public IsLeapYear(TemporalAdapter<T> adapter, TemporalFormatter<T> formatter) {
        this.adapter = adapter;
        this.formatter = formatter;
    }

    protected boolean matchesSafely(T actual, Description mismatchDesc) {
        if (!this.adapter.asTemporal(actual).query(TemporalQueries.localDate()).isLeapYear()) {
            mismatchDesc.appendText("the date " + this.formatter.describe(actual) + " is not a leap year");
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("a leap year");
    }
}

