/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.temporal.ChronoField;
import org.exparity.hamcrest.date.core.TemporalAdapter;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsHour<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final int expected;
    private final TemporalAdapter<T> accessor;

    public IsHour(int expected, TemporalAdapter<T> accessor) {
        this.expected = expected;
        this.accessor = accessor;
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        int actualHour = this.accessor.asTemporal(actual).get(ChronoField.HOUR_OF_DAY);
        if (this.expected == actualHour) {
            return true;
        }
        mismatchDescription.appendText("the date has the hour " + actualHour);
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("the date has the hour " + this.expected);
    }
}

