/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.hbase;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.hbase.HBaseColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HBaseClient {
    private static final Logger logger = LoggerFactory.getLogger(HBaseClient.class);
    private final Connection _connection;

    public HBaseClient(Connection connection) {
        this._connection = connection;
    }

    public void insertRow(String tableName, HBaseColumn[] columns, Object[] values, int indexOfIdColumn) {
        if (tableName == null || columns == null || values == null || indexOfIdColumn >= values.length || values[indexOfIdColumn] == null) {
            throw new IllegalArgumentException("Can't insert a row without having (correct) tableName, columns, values or indexOfIdColumn");
        }
        if (columns.length != values.length) {
            throw new IllegalArgumentException("The amount of columns don't match the amount of values");
        }
        try (Table table = this._connection.getTable(TableName.valueOf((String)tableName));){
            Put put = new Put(this.getValueAsByteArray(values[indexOfIdColumn]));
            for (int i = 0; i < columns.length; ++i) {
                if (i == indexOfIdColumn) continue;
                byte[] columnFamily = Bytes.toBytes((String)columns[i].getColumnFamily());
                byte[] qualifier = null;
                qualifier = columns[i].getQualifier() != null ? Bytes.toBytes((String)columns[i].getQualifier()) : Bytes.toBytes((String)new String(""));
                byte[] value = this.getValueAsByteArray(values[i]);
                if (value == null) {
                    logger.info("The value of column '{}' is null. This insertion is skipped", (Object)columns[i].getName());
                    continue;
                }
                put.addColumn(columnFamily, qualifier, value);
            }
            table.put(put);
        }
        catch (IOException e) {
            throw new MetaModelException((Exception)e);
        }
    }

    public void deleteRow(String tableName, Object rowKey) {
        if (tableName == null || rowKey == null) {
            throw new IllegalArgumentException("Can't delete a row without having tableName or rowKey");
        }
        byte[] rowKeyAsByteArray = this.getValueAsByteArray(rowKey);
        if (rowKeyAsByteArray.length > 0) {
            try (Table table = this._connection.getTable(TableName.valueOf((String)tableName));){
                if (this.rowExists(table, rowKeyAsByteArray)) {
                    table.delete(new Delete(rowKeyAsByteArray));
                }
                logger.warn("Rowkey with value {} doesn't exist in the table", (Object)rowKey.toString());
            }
            catch (IOException e) {
                throw new MetaModelException((Exception)e);
            }
        } else {
            throw new IllegalArgumentException("Can't delete a row without an empty rowKey.");
        }
    }

    private boolean rowExists(Table table, byte[] rowKey) throws IOException {
        Get get = new Get(rowKey);
        return !table.get(get).isEmpty();
    }

    public void createTable(String tableName, Set<String> columnFamilies) {
        this.checkTableAndColumnFamilies(tableName, columnFamilies);
        try (Admin admin = this._connection.getAdmin();){
            TableDescriptorBuilder tableBuilder = this.getTableDescriptorBuilder(tableName, columnFamilies);
            admin.createTable(tableBuilder.build());
        }
        catch (IOException e) {
            throw new MetaModelException((Exception)e);
        }
    }

    public void createTable(String tableName, Set<String> columnFamilies, byte[][] splitKeys) {
        this.checkTableAndColumnFamilies(tableName, columnFamilies);
        try (Admin admin = this._connection.getAdmin();){
            TableDescriptorBuilder tableBuilder = this.getTableDescriptorBuilder(tableName, columnFamilies);
            admin.createTable(tableBuilder.build(), splitKeys);
        }
        catch (IOException e) {
            throw new MetaModelException((Exception)e);
        }
    }

    private TableDescriptorBuilder getTableDescriptorBuilder(String tableName, Set<String> columnFamilies) {
        TableName hBasetableName = TableName.valueOf((String)tableName);
        TableDescriptorBuilder tableBuilder = TableDescriptorBuilder.newBuilder((TableName)hBasetableName);
        for (String columnFamily : columnFamilies) {
            if (columnFamily.equals("_id")) continue;
            ColumnFamilyDescriptor columnDescriptor = ColumnFamilyDescriptorBuilder.of((String)columnFamily);
            tableBuilder.setColumnFamily(columnDescriptor);
        }
        return tableBuilder;
    }

    private void checkTableAndColumnFamilies(String tableName, Set<String> columnFamilies) {
        if (tableName == null || columnFamilies == null || columnFamilies.isEmpty()) {
            throw new IllegalArgumentException("Can't create a table without having the tableName or columnFamilies");
        }
    }

    public void dropTable(String tableName) {
        if (tableName == null) {
            throw new IllegalArgumentException("Can't drop a table without having the tableName");
        }
        try (Admin admin = this._connection.getAdmin();){
            TableName hBasetableName = TableName.valueOf((String)tableName);
            admin.disableTable(hBasetableName);
            admin.deleteTable(hBasetableName);
        }
        catch (IOException e) {
            throw new MetaModelException((Exception)e);
        }
    }

    private byte[] getValueAsByteArray(Object value) {
        byte[] valueAsByteArray = value == null ? null : (value instanceof byte[] ? (byte[])value : Bytes.toBytes((String)value.toString()));
        return valueAsByteArray;
    }
}

