/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.csv;

import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvValidationException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.metamodel.csv.CsvConfiguration;
import org.apache.metamodel.csv.CsvSchema;
import org.apache.metamodel.schema.AbstractTable;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.Relationship;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.schema.naming.ColumnNamingContext;
import org.apache.metamodel.schema.naming.ColumnNamingContextImpl;
import org.apache.metamodel.schema.naming.ColumnNamingSession;
import org.apache.metamodel.schema.naming.ColumnNamingStrategy;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.LegacyDeserializationObjectInputStream;

final class CsvTable
extends AbstractTable {
    private static final long serialVersionUID = 1L;
    private final CsvSchema _schema;
    private final String _tableName;
    private List<Column> _columns;

    public CsvTable(CsvSchema schema, String tableName, List<String> columnNames) {
        this(schema, tableName);
        this._columns = this.buildColumns(columnNames);
    }

    public CsvTable(CsvSchema schema, String tableName) {
        this._schema = schema;
        this._tableName = tableName;
    }

    public String getName() {
        if (this._tableName == null) {
            String schemaName = this._schema.getName();
            return schemaName.substring(0, schemaName.length() - 4);
        }
        return this._tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Column> getColumns() {
        if (this._columns == null) {
            CsvTable csvTable = this;
            synchronized (csvTable) {
                if (this._columns == null) {
                    this._columns = this.buildColumns();
                }
            }
        }
        return this._columns;
    }

    private List<Column> buildColumns() {
        List<Column> list;
        CSVReader reader = null;
        try {
            reader = this._schema.getDataContext().createCsvReader(0);
            int columnNameLineNumber = this._schema.getDataContext().getConfiguration().getColumnNameLineNumber();
            for (int i = 1; i < columnNameLineNumber; ++i) {
                reader.readNext();
            }
            List<String> columnHeaders = Arrays.asList(Optional.ofNullable(reader.readNext()).orElse(new String[0]));
            reader.close();
            list = this.buildColumns(columnHeaders);
        }
        catch (CsvValidationException | IOException e) {
            try {
                throw new IllegalStateException("Exception reading from resource: " + this._schema.getDataContext().getResource().getName(), e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{reader});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{reader});
        return list;
    }

    private List<Column> buildColumns(List<String> columnNames) {
        if (columnNames == null) {
            return new ArrayList<Column>();
        }
        CsvConfiguration configuration = this._schema.getDataContext().getConfiguration();
        int columnNameLineNumber = configuration.getColumnNameLineNumber();
        boolean nullable = !configuration.isFailOnInconsistentRowLength();
        ColumnNamingStrategy columnNamingStrategy = configuration.getColumnNamingStrategy();
        ArrayList<Column> columns = new ArrayList<Column>();
        try (ColumnNamingSession namingSession = columnNamingStrategy.startColumnNamingSession();){
            for (int i = 0; i < columnNames.size(); ++i) {
                String intrinsicColumnName = columnNameLineNumber == 0 ? null : columnNames.get(i);
                String columnName = namingSession.getNextColumnName((ColumnNamingContext)new ColumnNamingContextImpl((Table)this, intrinsicColumnName, i));
                MutableColumn column = new MutableColumn(columnName, ColumnType.STRING, (Table)this, i, null, null, Boolean.valueOf(nullable), null, false, null);
                columns.add((Column)column);
            }
        }
        return columns;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public TableType getType() {
        return TableType.TABLE;
    }

    public Collection<Relationship> getRelationships() {
        return Collections.emptyList();
    }

    public String getRemarks() {
        return null;
    }

    public String getQuote() {
        return null;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getFields = stream.readFields();
        List<Column> columns = getFields.get("_columns", null);
        if (columns instanceof Column[]) {
            columns = Arrays.asList((Column[])columns);
        }
        Object schema = getFields.get("_schema", null);
        Object tableName = getFields.get("_tableName", null);
        LegacyDeserializationObjectInputStream.setField(CsvTable.class, (Object)((Object)this), (String)"_columns", columns);
        LegacyDeserializationObjectInputStream.setField(CsvTable.class, (Object)((Object)this), (String)"_schema", (Object)schema);
        LegacyDeserializationObjectInputStream.setField(CsvTable.class, (Object)((Object)this), (String)"_tableName", (Object)tableName);
    }
}

