/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.csv;

import java.util.List;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.create.AbstractTableCreationBuilder;
import org.apache.metamodel.csv.CsvDataContext;
import org.apache.metamodel.csv.CsvSchema;
import org.apache.metamodel.csv.CsvTable;
import org.apache.metamodel.csv.CsvUpdateCallback;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;

final class CsvCreateTableBuilder
extends AbstractTableCreationBuilder<CsvUpdateCallback> {
    public CsvCreateTableBuilder(CsvUpdateCallback updateCallback, Schema schema, String name) {
        super((UpdateCallback)updateCallback, schema, name);
        if (!(schema instanceof CsvSchema)) {
            throw new IllegalArgumentException("Not a valid CSV schema: " + schema);
        }
    }

    public Table execute() {
        CsvUpdateCallback csvUpdateCallback = (CsvUpdateCallback)this.getUpdateCallback();
        MutableTable table = this.getTable();
        List columnNames = table.getColumnNames();
        CsvDataContext csvDataContext = (CsvDataContext)csvUpdateCallback.getDataContext();
        if (csvDataContext.getConfiguration().getColumnNameLineNumber() != 0) {
            csvUpdateCallback.writeRow(columnNames.toArray(new String[columnNames.size()]), false);
        }
        CsvSchema schema = (CsvSchema)table.getSchema();
        CsvTable csvTable = new CsvTable(schema, table.getName(), table.getColumnNames());
        schema.setTable(csvTable);
        return csvTable;
    }
}

