/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.util;

import java.io.Serializable;
import java.util.StringTokenizer;

public final class WildcardPattern
implements Serializable {
    private static final long serialVersionUID = 857462137797209624L;
    private final boolean _startsWithDelim;
    private final boolean _endsWithDelim;
    private String _pattern;
    private char _wildcard;

    public WildcardPattern(String pattern, char wildcard) {
        this._pattern = pattern;
        this._wildcard = wildcard;
        if (this._pattern.isEmpty()) {
            this._endsWithDelim = false;
            this._startsWithDelim = false;
        } else {
            this._startsWithDelim = this._pattern.charAt(0) == this._wildcard;
            this._endsWithDelim = this._pattern.charAt(pattern.length() - 1) == this._wildcard;
        }
    }

    public boolean matches(String value) {
        if (value == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(this._pattern, Character.toString(this._wildcard));
        int charIndex = 0;
        while (st.hasMoreTokens()) {
            int oldIndex = charIndex;
            String token = st.nextToken();
            charIndex = value.indexOf(token, charIndex);
            if (charIndex == -1 || !this._startsWithDelim && oldIndex == 0 && charIndex != 0) {
                return false;
            }
            charIndex += token.length();
        }
        return this._endsWithDelim || charIndex == value.length();
    }
}

