/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.metamodel.util.AbstractResource;
import org.apache.metamodel.util.ResourceException;

public class UrlResource
extends AbstractResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final URI _uri;

    public UrlResource(URL url) {
        try {
            this._uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public UrlResource(URI uri) {
        this._uri = uri;
    }

    public UrlResource(String urlString) {
        try {
            this._uri = new URI(urlString);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String toString() {
        return "UrlResource[" + this._uri + "]";
    }

    public URI getUri() {
        return this._uri;
    }

    @Override
    public String getName() {
        String lastPart;
        int lastBackSlash;
        String name = this._uri.toString();
        int lastSlash = name.lastIndexOf(47);
        int lastIndex = Math.max(lastSlash, lastBackSlash = name.lastIndexOf(92));
        if (lastIndex != -1 && !"".equals(lastPart = name.substring(lastIndex + 1))) {
            return lastPart;
        }
        return name;
    }

    @Override
    public String getQualifiedPath() {
        return this._uri.toString();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public OutputStream write() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream append() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isExists() {
        return true;
    }

    @Override
    public long getSize() {
        return -1L;
    }

    @Override
    public long getLastModified() {
        return -1L;
    }

    @Override
    public InputStream read() throws ResourceException {
        try {
            return this._uri.toURL().openStream();
        }
        catch (Exception e) {
            throw new ResourceException(this, "Failed to open InputStream", e);
        }
    }
}

