/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.util;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import org.apache.metamodel.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeComparator
implements Comparator<Object> {
    private static final Logger logger = LoggerFactory.getLogger(TimeComparator.class);
    private static final String[] prototypePatterns = new String[]{"yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "HH:mm:ss.SSS", "yyyy-MM-dd", "dd-MM-yyyy", "yy-MM-dd", "MM-dd-yyyy", "HH:mm:ss", "HH:mm"};
    private static final Comparator<Object> _instance = new TimeComparator();

    public static Comparator<Object> getComparator() {
        return _instance;
    }

    private TimeComparator() {
    }

    public static Comparable<Object> getComparable(Object o) {
        final Date dt1 = TimeComparator.toDate(o);
        return new Comparable<Object>(){

            public boolean equals(Object obj) {
                return _instance.equals(obj);
            }

            @Override
            public int compareTo(Object o) {
                return _instance.compare(dt1, o);
            }

            public String toString() {
                return "TimeComparable[time=" + dt1 + "]";
            }
        };
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        try {
            Date dt1 = TimeComparator.toDate(o1);
            Date dt2 = TimeComparator.toDate(o2);
            return dt1.compareTo(dt2);
        }
        catch (Exception e) {
            logger.error("Could not compare {} and {}", o1, o2);
            throw new RuntimeException(e);
        }
    }

    public static Date toDate(Object value) {
        Date result = null;
        if (value == null) {
            result = null;
        } else if (value instanceof Date) {
            result = (Date)value;
        } else if (value instanceof Calendar) {
            result = ((Calendar)value).getTime();
        } else if (value instanceof String) {
            result = TimeComparator.convertFromString((String)value);
        } else if (value instanceof Number) {
            result = TimeComparator.convertFromNumber((Number)value);
        }
        if (result == null) {
            logger.warn("Could not convert '{}' to date, returning null", value);
        }
        return result;
    }

    public static boolean isTimeBased(Object o) {
        return o instanceof Date || o instanceof Calendar;
    }

    private static Date convertFromString(String value) {
        try {
            long longValue = Long.parseLong(value);
            return TimeComparator.convertFromNumber(longValue);
        }
        catch (NumberFormatException longValue) {
            try {
                DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(Locale.US);
                SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", dateFormatSymbols);
                return dateFormat.parse(value);
            }
            catch (ParseException parseException) {
                for (String prototypePattern : prototypePatterns) {
                    if (prototypePattern.length() != value.length()) continue;
                    try {
                        DateFormat dateFormat = DateUtils.createDateFormat(prototypePattern);
                        return dateFormat.parse(value);
                    }
                    catch (Exception exception) {
                        if (prototypePattern.indexOf(45) == -1) continue;
                        try {
                            DateFormat dateFormat = DateUtils.createDateFormat(prototypePattern.replaceAll("\\-", "\\."));
                            return dateFormat.parse(value);
                        }
                        catch (Exception exception2) {
                            try {
                                DateFormat dateFormat = DateUtils.createDateFormat(prototypePattern.replaceAll("\\-", "\\/"));
                                return dateFormat.parse(value);
                            }
                            catch (Exception exception3) {
                                // empty catch block
                            }
                        }
                    }
                }
                return null;
            }
        }
    }

    private static Date convertFromNumber(Number value) {
        Number numberValue = value;
        long longValue = numberValue.longValue();
        String stringValue = Long.toString(longValue);
        if (stringValue.length() == 8 && (stringValue.startsWith("1") || stringValue.startsWith("2"))) {
            try {
                return DateUtils.createDateFormat("yyyyMMdd").parse(stringValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (stringValue.length() == 6) {
            try {
                return DateUtils.createDateFormat("yyMMdd").parse(stringValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (longValue > 5000000L) {
            return new Date(longValue);
        }
        return new Date(longValue * 1000L * 60L * 60L * 24L);
    }
}

