/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.util;

import java.net.URI;
import org.apache.metamodel.factory.ResourceFactoryRegistryImpl;
import org.apache.metamodel.factory.ResourceProperties;
import org.apache.metamodel.factory.SimpleResourceProperties;
import org.apache.metamodel.factory.UnsupportedResourcePropertiesException;
import org.apache.metamodel.util.Resource;

public class ResourceUtils {
    public static Resource toResource(URI uri) throws UnsupportedResourcePropertiesException {
        return ResourceUtils.toResource(new SimpleResourceProperties(uri));
    }

    public static Resource toResource(String uri) throws UnsupportedResourcePropertiesException {
        return ResourceUtils.toResource(new SimpleResourceProperties(uri));
    }

    public static Resource toResource(ResourceProperties resourceProperties) throws UnsupportedResourcePropertiesException {
        return ResourceFactoryRegistryImpl.getDefaultInstance().createResource(resourceProperties);
    }

    public static String getParentName(Resource resource) {
        int lastIndexOfBackSlash;
        String name = resource.getName();
        String qualifiedPath = resource.getQualifiedPath();
        if (!qualifiedPath.endsWith(name)) {
            return "";
        }
        int indexOfChild = qualifiedPath.length() - name.length();
        if (indexOfChild <= 0) {
            return "";
        }
        String parentQualifiedPath = qualifiedPath.substring(0, indexOfChild);
        if ("/".equals(parentQualifiedPath)) {
            return parentQualifiedPath;
        }
        int lastIndexOfSlash = (parentQualifiedPath = parentQualifiedPath.substring(0, parentQualifiedPath.length() - 1)).lastIndexOf(47);
        int lastIndexToUse = Math.max(lastIndexOfSlash, lastIndexOfBackSlash = parentQualifiedPath.lastIndexOf(92));
        if (lastIndexToUse == -1) {
            return parentQualifiedPath;
        }
        String parentName = parentQualifiedPath.substring(lastIndexToUse + 1);
        return parentName;
    }
}

