/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.util;

import java.util.Comparator;
import org.apache.metamodel.util.BooleanComparator;
import org.apache.metamodel.util.NumberComparator;
import org.apache.metamodel.util.TimeComparator;
import org.apache.metamodel.util.ToStringComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectComparator
implements Comparator<Object> {
    private static final Logger logger = LoggerFactory.getLogger(ObjectComparator.class);
    private static final Comparator<Object> _instance = new ObjectComparator();

    public static Comparator<Object> getComparator() {
        return _instance;
    }

    private ObjectComparator() {
    }

    public static Comparable<Object> getComparable(final Object o) {
        return new Comparable<Object>(){

            public boolean equals(Object obj) {
                return _instance.equals(obj);
            }

            @Override
            public int compareTo(Object o2) {
                return _instance.compare(o, o2);
            }

            public String toString() {
                return "ObjectComparable[object=" + o + "]";
            }
        };
    }

    @Override
    public int compare(Object o1, Object o2) {
        logger.debug("compare({},{})", o1, o2);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof Number && o1 instanceof Number) {
            return NumberComparator.getComparator().compare(o1, o2);
        }
        if (TimeComparator.isTimeBased(o1) && TimeComparator.isTimeBased(o2)) {
            return TimeComparator.getComparator().compare(o1, o2);
        }
        if (BooleanComparator.isBoolean(o1) && BooleanComparator.isBoolean(o2)) {
            return BooleanComparator.getComparator().compare(o1, o2);
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            Comparable c1 = (Comparable)o1;
            Comparable c2 = (Comparable)o2;
            if (c1.getClass().isAssignableFrom(c2.getClass())) {
                return c1.compareTo(o2);
            }
            if (o2.getClass().isAssignableFrom(c1.getClass())) {
                return -1 * c2.compareTo(o1);
            }
        }
        logger.debug("Using ToStringComparator because no apparent better comparison method could be found");
        return ToStringComparator.getComparator().compare(o1, o2);
    }
}

