/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Comparator;
import org.apache.metamodel.query.AggregateFunction;
import org.apache.metamodel.query.FunctionType;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.SuperColumnType;
import org.apache.metamodel.util.AggregateBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyDeserializationObjectInputStream
extends ObjectInputStream {
    private static final Logger logger = LoggerFactory.getLogger(LegacyDeserializationObjectInputStream.class);
    private static final String OLD_CLASS_NAME_COLUMN_TYPE = "org.eobjects.metamodel.schema.ColumnType";
    private static final String CLASS_NAME_OPERATOR_TYPE = "org.apache.metamodel.query.OperatorType";
    private static final String CLASS_NAME_FUNCTION_TYPE = "org.apache.metamodel.query.FunctionType";

    public static void setField(Class<?> cls, Object instance, String fieldName, Object value) {
        try {
            Field field = cls.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Unable to assign field '" + cls.getSimpleName() + '.' + fieldName + "' to value: " + value, e);
        }
    }

    public LegacyDeserializationObjectInputStream(InputStream in) throws IOException, SecurityException {
        super(in);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String className = desc.getName();
        if (className.startsWith("org.eobjects.metamodel") || className.startsWith("[Lorg.eobjects.metamodel")) {
            String newClassName = OLD_CLASS_NAME_COLUMN_TYPE.equals(className) ? LegacyColumnType.class.getName() : className.replace("org.eobjects", "org.apache");
            return Class.forName(newClassName);
        }
        return super.resolveClass(desc);
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        String className;
        ObjectStreamClass objectStreamClass = super.readClassDescriptor();
        switch (className = objectStreamClass.getName()) {
            case "org.eobjects.metamodel.schema.ColumnType": {
                ObjectStreamClass legacyColumnTypeResult = ObjectStreamClass.lookup(LegacyColumnType.class);
                return legacyColumnTypeResult;
            }
            case "org.apache.metamodel.query.OperatorType": {
                if (!this.isEnumExpected(objectStreamClass)) break;
                ObjectStreamClass legacyOperatorTypeResult = ObjectStreamClass.lookup(LegacyOperatorType.class);
                return legacyOperatorTypeResult;
            }
            case "org.apache.metamodel.query.FunctionType": {
                if (!this.isEnumExpected(objectStreamClass)) break;
                ObjectStreamClass legacyOperatorTypeResult = ObjectStreamClass.lookup(LegacyFunctionType.class);
                return legacyOperatorTypeResult;
            }
        }
        return objectStreamClass;
    }

    private boolean isEnumExpected(ObjectStreamClass objectStreamClass) {
        try {
            Field initializedField = ObjectStreamClass.class.getDeclaredField("initialized");
            initializedField.setAccessible(true);
            Boolean initialized = (Boolean)initializedField.get(objectStreamClass);
            if (!initialized.booleanValue()) {
                Method initMethod = ObjectStreamClass.class.getDeclaredMethod("initNonProxy", ObjectStreamClass.class, Class.class, ClassNotFoundException.class, ObjectStreamClass.class);
                initMethod.setAccessible(true);
                initMethod.invoke((Object)objectStreamClass, objectStreamClass, null, null, null);
            }
        }
        catch (NoSuchFieldError e) {
            logger.debug("Failed to access boolean field 'initialized' in {}", (Object)objectStreamClass.getName(), (Object)e);
        }
        catch (Exception e) {
            logger.debug("Failed to access invoke ObjectStreamClass.initialize() to prepare {}", (Object)objectStreamClass.getName(), (Object)e);
        }
        try {
            Method isEnumMethod = ObjectStreamClass.class.getDeclaredMethod("isEnum", new Class[0]);
            isEnumMethod.setAccessible(true);
            Boolean result = (Boolean)isEnumMethod.invoke((Object)objectStreamClass, new Object[0]);
            return result;
        }
        catch (Exception e) {
            logger.warn("Failed to access and invoke ObjectStreamClass.isEnum to determine if {} is an enum", (Object)objectStreamClass.getName(), (Object)e);
            return false;
        }
    }

    protected static enum LegacyColumnType implements ColumnType
    {
        CHAR(ColumnType.CHAR),
        VARCHAR(ColumnType.VARCHAR),
        LONGVARCHAR(ColumnType.LONGVARCHAR),
        CLOB(ColumnType.CLOB),
        NCHAR(ColumnType.NCHAR),
        NVARCHAR(ColumnType.NVARCHAR),
        LONGNVARCHAR(ColumnType.LONGNVARCHAR),
        NCLOB(ColumnType.NCLOB),
        TINYINT(ColumnType.TINYINT),
        SMALLINT(ColumnType.SMALLINT),
        INTEGER(ColumnType.INTEGER),
        BIGINT(ColumnType.BIGINT),
        FLOAT(ColumnType.FLOAT),
        REAL(ColumnType.REAL),
        DOUBLE(ColumnType.DOUBLE),
        NUMERIC(ColumnType.NUMERIC),
        DECIMAL(ColumnType.DECIMAL),
        DATE(ColumnType.DATE),
        TIME(ColumnType.TIME),
        TIMESTAMP(ColumnType.TIMESTAMP),
        BIT(ColumnType.BIT),
        BOOLEAN(ColumnType.BOOLEAN),
        BINARY(ColumnType.BINARY),
        VARBINARY(ColumnType.VARBINARY),
        LONGVARBINARY(ColumnType.LONGVARBINARY),
        BLOB(ColumnType.BLOB),
        NULL(ColumnType.NULL),
        OTHER(ColumnType.OTHER),
        JAVA_OBJECT(ColumnType.JAVA_OBJECT),
        DISTINCT(ColumnType.DISTINCT),
        STRUCT(ColumnType.STRUCT),
        ARRAY(ColumnType.ARRAY),
        REF(ColumnType.REF),
        DATALINK(ColumnType.DATALINK),
        ROWID(ColumnType.ROWID),
        SQLXML(ColumnType.SQLXML),
        LIST(ColumnType.LIST),
        MAP(ColumnType.MAP);

        private final ColumnType _delegate;

        private LegacyColumnType(ColumnType delegate) {
            this._delegate = delegate;
        }

        @Override
        public String getName() {
            return this._delegate.getName();
        }

        @Override
        public Comparator<Object> getComparator() {
            return this._delegate.getComparator();
        }

        @Override
        public boolean isBoolean() {
            return this._delegate.isBoolean();
        }

        @Override
        public boolean isBinary() {
            return this._delegate.isBinary();
        }

        @Override
        public boolean isNumber() {
            return this._delegate.isNumber();
        }

        @Override
        public boolean isTimeBased() {
            return this._delegate.isTimeBased();
        }

        @Override
        public boolean isLiteral() {
            return this._delegate.isLiteral();
        }

        @Override
        public boolean isLargeObject() {
            return this._delegate.isLargeObject();
        }

        @Override
        public Class<?> getJavaEquivalentClass() {
            return this._delegate.getJavaEquivalentClass();
        }

        @Override
        public SuperColumnType getSuperType() {
            return this._delegate.getSuperType();
        }

        @Override
        public int getJdbcType() throws IllegalStateException {
            return this._delegate.getJdbcType();
        }
    }

    protected static enum LegacyOperatorType implements OperatorType
    {
        EQUALS_TO(OperatorType.EQUALS_TO),
        DIFFERENT_FROM(OperatorType.DIFFERENT_FROM),
        LIKE(OperatorType.LIKE),
        GREATER_THAN(OperatorType.GREATER_THAN),
        GREATER_THAN_OR_EQUAL(OperatorType.GREATER_THAN_OR_EQUAL),
        LESS_THAN(OperatorType.LESS_THAN),
        LESS_THAN_OR_EQUAL(OperatorType.LESS_THAN_OR_EQUAL),
        IN(OperatorType.IN);

        private final OperatorType _delegate;

        private LegacyOperatorType(OperatorType delegate) {
            this._delegate = delegate;
        }

        @Override
        public boolean isSpaceDelimited() {
            return this._delegate.isSpaceDelimited();
        }

        @Override
        public String toSql() {
            return this._delegate.toSql();
        }
    }

    protected static enum LegacyFunctionType implements AggregateFunction
    {
        COUNT(FunctionType.COUNT),
        AVG(FunctionType.AVG),
        SUM(FunctionType.SUM),
        MAX(FunctionType.MAX),
        MIN(FunctionType.MIN);

        private final AggregateFunction _delegate;

        private LegacyFunctionType(AggregateFunction delegate) {
            this._delegate = delegate;
        }

        @Override
        public ColumnType getExpectedColumnType(ColumnType type) {
            return this._delegate.getExpectedColumnType(type);
        }

        @Override
        public String getFunctionName() {
            return this._delegate.getFunctionName();
        }

        @Override
        public AggregateBuilder<?> createAggregateBuilder() {
            return this._delegate.createAggregateBuilder();
        }

        @Override
        public Object evaluate(Object ... values) {
            return this._delegate.evaluate(values);
        }
    }
}

