/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.metamodel.util.AbstractResource;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.ResourceException;

public class InMemoryResource
extends AbstractResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String _path;
    private byte[] _contents;
    private long _lastModified;

    public InMemoryResource(String path) {
        this(path, new byte[0], -1L);
    }

    public InMemoryResource(String path, byte[] contents, long lastModified) {
        this._path = path;
        this._contents = contents;
        this._lastModified = lastModified;
    }

    @Override
    public String toString() {
        return "InMemoryResource[" + this._path + "]";
    }

    @Override
    public String getName() {
        String lastPart;
        int lastBackSlash;
        String name = this._path;
        int lastSlash = name.lastIndexOf(47);
        int lastIndex = Math.max(lastSlash, lastBackSlash = name.lastIndexOf(92));
        if (lastIndex != -1 && !"".equals(lastPart = name.substring(lastIndex + 1))) {
            return lastPart;
        }
        return name;
    }

    @Override
    public String getQualifiedPath() {
        return this._path;
    }

    public String getPath() {
        return this._path;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isExists() {
        return true;
    }

    @Override
    public long getSize() {
        return this._contents.length;
    }

    @Override
    public long getLastModified() {
        return this._lastModified;
    }

    @Override
    public OutputStream write() throws ResourceException {
        return this.createOutputStream(false);
    }

    @Override
    public OutputStream append() throws ResourceException {
        return this.createOutputStream(true);
    }

    private OutputStream createOutputStream(boolean append) throws ResourceException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(){

            @Override
            public void flush() throws IOException {
                super.flush();
                InMemoryResource.access$002(InMemoryResource.this, this.toByteArray());
                InMemoryResource.this._lastModified = System.currentTimeMillis();
            }
        };
        if (append) {
            try {
                out.write(this._contents);
            }
            catch (IOException e) {
                throw new ResourceException((Resource)this, (Exception)e);
            }
        }
        return out;
    }

    @Override
    public InputStream read() throws ResourceException {
        return new ByteArrayInputStream(this._contents);
    }

    static /* synthetic */ byte[] access$002(InMemoryResource x0, byte[] x1) {
        x0._contents = x1;
        return x1;
    }
}

