/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.metamodel.util.AbstractDirectoryInputStream;
import org.apache.metamodel.util.AbstractResource;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.ResourceException;

public class FileResource
extends AbstractResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final File _file;

    public FileResource(String filename) {
        this._file = new File(filename);
    }

    public FileResource(File file) {
        this._file = file;
    }

    @Override
    public String toString() {
        return "FileResource[" + this._file.getPath() + "]";
    }

    @Override
    public String getName() {
        return this._file.getName();
    }

    @Override
    public String getQualifiedPath() {
        try {
            return this._file.getCanonicalPath();
        }
        catch (IOException e) {
            return this._file.getAbsolutePath();
        }
    }

    @Override
    public boolean isReadOnly() {
        if (!this.isExists()) {
            return false;
        }
        if (this._file.isDirectory()) {
            return true;
        }
        boolean canWrite = this._file.canWrite();
        return !canWrite;
    }

    @Override
    public OutputStream write() throws ResourceException {
        if (this._file.isDirectory()) {
            throw new ResourceException((Resource)this, "Cannot write to directory: " + this._file);
        }
        return FileHelper.getOutputStream(this._file);
    }

    @Override
    public OutputStream append() throws ResourceException {
        return FileHelper.getOutputStream(this._file, true);
    }

    public File getFile() {
        return this._file;
    }

    @Override
    public boolean isExists() {
        return this._file.exists();
    }

    @Override
    public long getSize() {
        if (this._file.isDirectory()) {
            File[] children;
            long size = 0L;
            for (File file : children = this.getChildren()) {
                long length = file.length();
                if (length == -1L) {
                    return -1L;
                }
                size += length;
            }
            return size;
        }
        return this._file.length();
    }

    @Override
    public long getLastModified() {
        if (this._file.isDirectory()) {
            File[] children;
            long lastModified = -1L;
            for (File file : children = this.getChildren()) {
                long l = file.lastModified();
                if (l == 0L) continue;
                lastModified = Math.max(lastModified, l);
            }
            return lastModified;
        }
        long lastModified = this._file.lastModified();
        if (lastModified == 0L) {
            return -1L;
        }
        return lastModified;
    }

    @Override
    public InputStream read() throws ResourceException {
        if (this._file.isDirectory()) {
            return new DirectoryInputStream();
        }
        InputStream in = FileHelper.getInputStream(this._file);
        return in;
    }

    private File[] getChildren() {
        return this._file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        });
    }

    private class DirectoryInputStream
    extends AbstractDirectoryInputStream<File> {
        public DirectoryInputStream() {
            Object[] unsortedFiles = FileResource.this.getChildren();
            if (unsortedFiles == null) {
                this._files = new File[0];
            } else {
                Arrays.sort(unsortedFiles);
                this._files = unsortedFiles;
            }
        }

        @Override
        InputStream openStream(int index) throws IOException {
            return FileHelper.getInputStream(((File[])this._files)[index]);
        }
    }
}

