/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static Object find(Object collection, String key) {
        if (collection == null || key == null) {
            return null;
        }
        if (collection instanceof Map) {
            Map map = (Map)collection;
            Object result = map.get(key);
            if (result == null) {
                return CollectionUtils.find(map, key, 0);
            }
            return result;
        }
        if (collection instanceof List || collection.getClass().isArray()) {
            return CollectionUtils.find(collection, key, 0);
        }
        return null;
    }

    private static Object find(Object collection, String key, int fromIndex) {
        boolean hasBracket;
        int indexOfDot = key.indexOf(46, fromIndex);
        int indexOfBracket = key.indexOf(91, fromIndex);
        int indexOfEndBracket = -1;
        int arrayIndex = -1;
        boolean hasDot = indexOfDot != -1;
        boolean bl = hasBracket = indexOfBracket != -1;
        if (hasBracket) {
            indexOfEndBracket = key.indexOf(93, indexOfBracket);
            boolean bl2 = hasBracket = indexOfEndBracket != -1;
            if (hasBracket) {
                String indexString = key.substring(indexOfBracket + 1, indexOfEndBracket);
                try {
                    arrayIndex = Integer.parseInt(indexString);
                    if (collection instanceof List || collection.getClass().isArray()) {
                        Object obj = null;
                        if (collection instanceof List) {
                            obj = ((List)collection).get(arrayIndex);
                        } else if (collection.getClass().isArray()) {
                            obj = Array.get(collection, arrayIndex);
                        }
                        key = key.substring(indexOfEndBracket + 1, key.length());
                        if (key.startsWith(".")) {
                            key = key.substring(1, key.length());
                        }
                        if (key.isEmpty()) {
                            return obj;
                        }
                        return CollectionUtils.find(obj, key);
                    }
                }
                catch (NumberFormatException e) {
                    hasBracket = false;
                }
            }
        }
        if (hasDot && hasBracket) {
            if (indexOfDot > indexOfBracket) {
                hasDot = false;
            } else {
                hasBracket = false;
            }
        }
        if (hasDot) {
            String prefix = key.substring(0, indexOfDot);
            Object nestedObject = ((Map)collection).get(prefix);
            if (nestedObject == null) {
                return CollectionUtils.find(collection, key, indexOfDot + 1);
            }
            if (nestedObject instanceof Map) {
                String remainingPart = key.substring(indexOfDot + 1);
                Map nestedMap = (Map)nestedObject;
                return CollectionUtils.find(nestedMap, remainingPart);
            }
        }
        if (hasBracket) {
            String prefix;
            Object nestedObject = null;
            if (collection instanceof Map && (nestedObject = (Object)((Map)collection).get(prefix = key.substring(0, indexOfBracket))) == null) {
                return CollectionUtils.find(collection, key, indexOfBracket + 1);
            }
            String remainingPart = key.substring(indexOfEndBracket + 1);
            try {
                Object valueAtIndex = nestedObject instanceof List ? (Object)((List)nestedObject).get(arrayIndex) : (nestedObject != null && nestedObject.getClass().isArray() ? Array.get(nestedObject, arrayIndex) : null);
                if (valueAtIndex != null) {
                    if (remainingPart.startsWith(".")) {
                        remainingPart = remainingPart.substring(1);
                    }
                    if (remainingPart.isEmpty()) {
                        return valueAtIndex;
                    }
                    return CollectionUtils.find(valueAtIndex, remainingPart);
                }
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        return null;
    }

    public static <E> E[] array(E[] existingArray, E ... elements) {
        if (existingArray == null) {
            return elements;
        }
        Object result = Array.newInstance(existingArray.getClass().getComponentType(), existingArray.length + elements.length);
        System.arraycopy(existingArray, 0, result, 0, existingArray.length);
        System.arraycopy(elements, 0, result, existingArray.length, elements.length);
        return (Object[])result;
    }

    public static <E> List<E> concat(boolean removeDuplicates, Collection<? extends E> firstCollection, Collection<?> ... collections) {
        ArrayList<Object> result;
        if (removeDuplicates) {
            result = new ArrayList();
            CollectionUtils.addElements(removeDuplicates, result, firstCollection);
        } else {
            result = new ArrayList<E>(firstCollection);
        }
        Collection<?>[] collectionArray = collections;
        int n = collectionArray.length;
        for (int i = 0; i < n; ++i) {
            Collection<?> collection;
            Collection<?> elems = collection = collectionArray[i];
            CollectionUtils.addElements(removeDuplicates, result, elems);
        }
        return result;
    }

    private static <E> void addElements(boolean removeDuplicates, List<E> result, Collection<? extends E> elements) {
        for (E item : elements) {
            if (removeDuplicates) {
                if (result.contains(item)) continue;
                result.add(item);
                continue;
            }
            result.add(item);
        }
    }

    public static <E> E[] arrayRemove(E[] array, E elementToRemove) {
        Object[] result = (Object[])CollectionUtils.arrayRemoveInternal(array, elementToRemove);
        return result;
    }

    public static Object arrayRemove(Object array, Object elementToRemove) {
        return CollectionUtils.arrayRemoveInternal(array, elementToRemove);
    }

    private static Object arrayRemoveInternal(Object array, Object elementToRemove) {
        boolean found = false;
        int oldLength = Array.getLength(array);
        if (oldLength == 0) {
            return array;
        }
        int newLength = oldLength - 1;
        Object result = Array.newInstance(array.getClass().getComponentType(), newLength);
        int nextIndex = 0;
        for (int i = 0; i < oldLength; ++i) {
            Object e = Array.get(array, i);
            if (e.equals(elementToRemove)) {
                found = true;
                continue;
            }
            if (nextIndex == newLength) break;
            Array.set(result, nextIndex, e);
            ++nextIndex;
        }
        if (!found) {
            return array;
        }
        return result;
    }

    public static <E> E[] arrayOf(Class<E> elementClass, Object arrayOrElement) {
        if (arrayOrElement == null) {
            return null;
        }
        if (arrayOrElement.getClass().isArray()) {
            return (Object[])arrayOrElement;
        }
        Object result = Array.newInstance(elementClass, 1);
        Array.set(result, 0, arrayOrElement);
        return (Object[])result;
    }

    public static <E> List<E> filter(E[] items, Predicate<? super E> predicate) {
        return CollectionUtils.filter(Arrays.asList(items), predicate);
    }

    public static <E> List<E> filter(Iterable<E> items, Predicate<? super E> predicate) {
        ArrayList<E> result = new ArrayList<E>();
        for (E e : items) {
            if (!predicate.test(e)) continue;
            result.add(e);
        }
        return result;
    }

    public static <I, O> List<O> map(I[] items, Function<? super I, O> func) {
        return CollectionUtils.map(Arrays.asList(items), func);
    }

    public static <I, O> List<O> map(Iterable<I> items, Function<? super I, O> func) {
        ArrayList<O> result = new ArrayList<O>();
        for (I item : items) {
            O output = func.apply(item);
            result.add(output);
        }
        return result;
    }

    public static <E> void forEach(E[] items, Consumer<? super E> action) {
        CollectionUtils.forEach(Arrays.asList(items), action);
    }

    public static <E> void forEach(Iterable<E> items, Consumer<? super E> action) {
        for (E item : items) {
            try {
                action.accept(item);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IllegalStateException("Action threw exception", e);
            }
        }
    }

    public static <E> boolean isNullOrEmpty(E[] arr) {
        return arr == null || arr.length == 0;
    }

    public static boolean isNullOrEmpty(Collection<?> col) {
        return col == null || col.isEmpty();
    }

    public static List<?> toList(Object obj) {
        ArrayList<Object> result;
        if (obj == null) {
            result = Collections.emptyList();
        } else if (obj instanceof List) {
            ArrayList<Object> list;
            result = list = (ArrayList<Object>)obj;
        } else if (obj.getClass().isArray()) {
            int length = Array.getLength(obj);
            result = new ArrayList(length);
            for (int i = 0; i < length; ++i) {
                result.add(Array.get(obj, i));
            }
        } else if (obj instanceof Iterable) {
            result = new ArrayList<Object>();
            for (Object item : (Iterable)obj) {
                result.add(item);
            }
        } else if (obj instanceof Iterator) {
            result = new ArrayList();
            Iterator it = (Iterator)obj;
            while (it.hasNext()) {
                result.add(it.next());
            }
        } else {
            result = new ArrayList(1);
            result.add(obj);
        }
        return result;
    }
}

