/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Function;
import org.apache.metamodel.util.Action;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.ResourceException;
import org.apache.metamodel.util.UncheckedFunc;

public abstract class AbstractResource
implements Resource {
    @Override
    public final void read(Action<InputStream> readCallback) {
        InputStream in = this.read();
        try {
            readCallback.run(in);
        }
        catch (Exception e) {
            try {
                throw new ResourceException(this, "Error occurred in read callback", e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose(in);
                throw throwable;
            }
        }
        FileHelper.safeClose(in);
    }

    @Override
    public <E> E read(Function<InputStream, E> readCallback) throws ResourceException {
        E e;
        InputStream in = this.read();
        try {
            E result;
            e = result = readCallback.apply(in);
        }
        catch (Exception e2) {
            try {
                throw new ResourceException(this, "Error occurred in read callback", e2);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose(in);
                throw throwable;
            }
        }
        FileHelper.safeClose(in);
        return e;
    }

    @Override
    public final <E> E read(UncheckedFunc<InputStream, E> readCallback) {
        E e;
        InputStream in = this.read();
        try {
            E result;
            e = result = readCallback.applyUnchecked(in);
        }
        catch (Exception e2) {
            try {
                throw new ResourceException(this, "Error occurred in read callback", e2);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose(in);
                throw throwable;
            }
        }
        FileHelper.safeClose(in);
        return e;
    }

    @Override
    public final void write(Action<OutputStream> writeCallback) throws ResourceException {
        OutputStream out = this.write();
        try {
            writeCallback.run(out);
        }
        catch (Exception e) {
            try {
                throw new ResourceException(this, "Error occurred in write callback", e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose(out);
                throw throwable;
            }
        }
        FileHelper.safeClose(out);
    }

    @Override
    public final void append(Action<OutputStream> appendCallback) throws ResourceException {
        OutputStream out = this.append();
        try {
            appendCallback.run(out);
        }
        catch (Exception e) {
            try {
                throw new ResourceException(this, "Error occurred in append callback", e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose(out);
                throw throwable;
            }
        }
        FileHelper.safeClose(out);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getQualifiedPath() + "]";
    }
}

