/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.metamodel.util.FileHelper;

public abstract class AbstractDirectoryInputStream<T>
extends InputStream {
    protected T[] _files;
    private int _currentFileIndex = -1;
    private InputStream _currentInputStream;

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int byteCount;
        if (this._currentInputStream != null && (byteCount = this._currentInputStream.read(b, off, len)) > 0) {
            return byteCount;
        }
        if (!this.openNextFile()) {
            return -1;
        }
        return this.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int count = this.read(b, 0, 1);
        if (count < 0) {
            return -1;
        }
        return b[0];
    }

    @Override
    public int available() throws IOException {
        if (this._currentInputStream != null) {
            return this._currentInputStream.available();
        }
        return 0;
    }

    private boolean openNextFile() throws IOException {
        if (this._currentInputStream != null) {
            FileHelper.safeClose(this._currentInputStream);
            this._currentInputStream = null;
        }
        ++this._currentFileIndex;
        if (this._currentFileIndex >= this._files.length) {
            return false;
        }
        this._currentInputStream = this.openStream(this._currentFileIndex);
        return true;
    }

    abstract InputStream openStream(int var1) throws IOException;

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this._currentInputStream != null) {
            FileHelper.safeClose(this._currentInputStream);
        }
    }
}

