/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema.naming;

import java.util.HashSet;
import java.util.Set;
import org.apache.metamodel.schema.naming.ColumnNamingContext;
import org.apache.metamodel.schema.naming.ColumnNamingSession;
import org.apache.metamodel.schema.naming.ColumnNamingStrategy;

public class UniqueColumnNamingStrategy
implements ColumnNamingStrategy {
    private static final long serialVersionUID = 1L;

    @Override
    public ColumnNamingSession startColumnNamingSession() {
        return new ColumnNamingSession(){
            private final Set<String> names = new HashSet<String>();

            @Override
            public String getNextColumnName(ColumnNamingContext ctx) {
                String intrinsicName = ctx.getIntrinsicColumnName();
                boolean unique = this.names.add(intrinsicName);
                if (unique) {
                    return intrinsicName;
                }
                String newName = null;
                int i = 2;
                while (!unique) {
                    newName = intrinsicName + '_' + i;
                    unique = this.names.add(newName);
                    ++i;
                }
                return newName;
            }

            @Override
            public void close() {
            }
        };
    }
}

