/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema.naming;

import org.apache.metamodel.schema.naming.ColumnNamingContext;
import org.apache.metamodel.schema.naming.ColumnNamingSession;
import org.apache.metamodel.schema.naming.ColumnNamingStrategy;

public class DelegatingIntrinsicSwitchColumnNamingStrategy
implements ColumnNamingStrategy {
    private static final long serialVersionUID = 1L;
    private final ColumnNamingStrategy intrinsicStrategy;
    private final ColumnNamingStrategy nonIntrinsicStrategy;

    public DelegatingIntrinsicSwitchColumnNamingStrategy(ColumnNamingStrategy intrinsicStrategy, ColumnNamingStrategy nonIntrinsicStrategy) {
        this.intrinsicStrategy = intrinsicStrategy;
        this.nonIntrinsicStrategy = nonIntrinsicStrategy;
    }

    @Override
    public ColumnNamingSession startColumnNamingSession() {
        final ColumnNamingSession intrinsicSession = this.intrinsicStrategy.startColumnNamingSession();
        final ColumnNamingSession nonIntrinsicSession = this.nonIntrinsicStrategy.startColumnNamingSession();
        return new ColumnNamingSession(){

            @Override
            public String getNextColumnName(ColumnNamingContext ctx) {
                String intrinsicColumnName = ctx.getIntrinsicColumnName();
                if (intrinsicColumnName == null || intrinsicColumnName.isEmpty()) {
                    return nonIntrinsicSession.getNextColumnName(ctx);
                }
                return intrinsicSession.getNextColumnName(ctx);
            }

            @Override
            public void close() {
                intrinsicSession.close();
                nonIntrinsicSession.close();
            }
        };
    }
}

