/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema.builder;

import org.apache.metamodel.convert.DocumentConverter;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Document;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.builder.DocumentSourceProvider;
import org.apache.metamodel.schema.builder.SchemaBuilder;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.ResourceUtils;

public class SingleMapColumnSchemaBuilder
implements SchemaBuilder,
DocumentConverter {
    private final String _schemaName;
    private final String _tableName;
    private final String _columnName;

    public SingleMapColumnSchemaBuilder(Resource resource, String columnName) {
        this(ResourceUtils.getParentName(resource), resource.getName(), columnName);
    }

    public SingleMapColumnSchemaBuilder(String schemaName, String tableName, String columnName) {
        this._schemaName = schemaName;
        this._tableName = tableName;
        this._columnName = columnName;
    }

    @Override
    public void offerSources(DocumentSourceProvider documentSourceProvider) {
    }

    @Override
    public String getSchemaName() {
        return this._schemaName;
    }

    @Override
    public MutableSchema build() {
        MutableSchema schema = new MutableSchema(this._schemaName);
        MutableTable table = new MutableTable(this._tableName, schema);
        table.addColumn(new MutableColumn(this._columnName, ColumnType.MAP, table, 1, null, null, false, null, false, null));
        schema.addTable(table);
        return schema;
    }

    @Override
    public DocumentConverter getDocumentConverter(Table table) {
        return this;
    }

    @Override
    public Row convert(Document document, DataSetHeader header) {
        assert (header.size() == 1);
        Object[] values = new Object[]{document.getValues()};
        return new DefaultRow(header, values);
    }
}

