/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema.builder;

import org.apache.metamodel.convert.DocumentConverter;
import org.apache.metamodel.data.Document;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.builder.ColumnNameAsKeysRowConverter;
import org.apache.metamodel.schema.builder.InferentialSchemaBuilder;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.ResourceUtils;

public class MultiTableInferentialSchemaBuilder
extends InferentialSchemaBuilder {
    private final String _discriminatorColumn;

    public MultiTableInferentialSchemaBuilder(Resource resource) {
        this(ResourceUtils.getParentName(resource));
    }

    public MultiTableInferentialSchemaBuilder(Resource resource, String discriminatorColumn) {
        this(ResourceUtils.getParentName(resource), discriminatorColumn);
    }

    public MultiTableInferentialSchemaBuilder(String schemaName) {
        this(schemaName, null);
    }

    public MultiTableInferentialSchemaBuilder(String schemaName, String discriminatorColumn) {
        super(schemaName);
        this._discriminatorColumn = discriminatorColumn;
    }

    @Override
    protected String determineTable(Document document) {
        Object value;
        Object tableName = this._discriminatorColumn == null ? document.getSourceCollectionName() : ((value = document.getValues().get(this._discriminatorColumn)) == null ? null : value.toString());
        if (tableName == null) {
            return "(other)";
        }
        return tableName;
    }

    @Override
    public DocumentConverter getDocumentConverter(Table table) {
        return new ColumnNameAsKeysRowConverter();
    }
}

