/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.metamodel.data.Document;
import org.apache.metamodel.data.DocumentSource;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.builder.InferentialColumnBuilder;
import org.apache.metamodel.schema.builder.TableBuilder;

public class InferentialTableBuilder
implements TableBuilder {
    private static final int MAX_SAMPLE_SIZE = 1000;
    private final String _tableName;
    private final Map<String, InferentialColumnBuilder> _columnBuilders;
    private final AtomicInteger _observationCounter;

    public InferentialTableBuilder(String tableName) {
        this._tableName = tableName;
        this._columnBuilders = new HashMap<String, InferentialColumnBuilder>();
        this._observationCounter = new AtomicInteger();
    }

    public void addObservation(Document document) {
        this._observationCounter.incrementAndGet();
        Map<String, ?> values = document.getValues();
        Set<Map.Entry<String, ?>> entries = values.entrySet();
        for (Map.Entry<String, ?> entry : entries) {
            String key = entry.getKey();
            if (key == null) continue;
            String column = key.toString();
            Object value = entry.getValue();
            InferentialColumnBuilder columnBuilder = this.getColumnBuilder(column);
            columnBuilder.addObservation(value);
        }
    }

    public int getObservationCount() {
        return this._observationCounter.get();
    }

    @Override
    public MutableTable buildTable() {
        int tableObservations = this.getObservationCount();
        TreeSet<String> columnNames = new TreeSet<String>(this._columnBuilders.keySet());
        MutableTable table = new MutableTable(this._tableName);
        int columnNumber = 0;
        for (String columnName : columnNames) {
            InferentialColumnBuilder columnBuilder = this.getColumnBuilder(columnName);
            MutableColumn column = columnBuilder.build();
            column.setTable(table);
            column.setColumnNumber(columnNumber);
            int columnObservations = columnBuilder.getObservationCount();
            if (tableObservations > columnObservations) {
                column.setNullable(true);
            }
            table.addColumn(column);
            ++columnNumber;
        }
        return table;
    }

    @Override
    public InferentialColumnBuilder getColumnBuilder(String columnName) {
        InferentialColumnBuilder columnBuilder = this._columnBuilders.get(columnName);
        if (columnBuilder == null) {
            columnBuilder = new InferentialColumnBuilder(columnName);
            this._columnBuilders.put(columnName, columnBuilder);
        }
        return columnBuilder;
    }

    @Override
    public void offerSource(DocumentSource documentSource) {
        while (this.getObservationCount() < 1000) {
            Document map = documentSource.next();
            if (map == null) {
                return;
            }
            this.addObservation(map);
        }
    }
}

