/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema.builder;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.ColumnTypeImpl;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.builder.ColumnBuilder;

public class InferentialColumnBuilder
implements ColumnBuilder {
    private final String _name;
    private final Set<ColumnType> _columnTypes;
    private final AtomicInteger _observationCounter;
    private boolean _nulls;

    public InferentialColumnBuilder(String columnName) {
        this._name = columnName;
        this._columnTypes = new HashSet<ColumnType>();
        this._observationCounter = new AtomicInteger();
        this._nulls = false;
    }

    public void addObservation(Object value) {
        this._observationCounter.incrementAndGet();
        if (value == null) {
            this._nulls = true;
            return;
        }
        Class<?> valueType = value.getClass();
        this.addObservation(valueType);
    }

    public void addObservation(ColumnType columnType) {
        this._observationCounter.incrementAndGet();
        if (columnType == null) {
            columnType = ColumnType.OTHER;
        }
        this._columnTypes.add(columnType);
    }

    public void addObservation(Class<?> valueType) {
        ColumnType columnType = ColumnTypeImpl.convertColumnType(valueType);
        this.addObservation(columnType);
    }

    public int getObservationCount() {
        return this._observationCounter.get();
    }

    @Override
    public MutableColumn build() {
        MutableColumn column = new MutableColumn(this._name);
        column.setType(this.detectType());
        if (this._nulls) {
            column.setNullable(true);
        }
        return column;
    }

    private ColumnType detectType() {
        if (this._columnTypes.isEmpty()) {
            return ColumnType.OTHER;
        }
        if (this._columnTypes.size() == 1) {
            return this._columnTypes.iterator().next();
        }
        boolean allStrings = true;
        boolean allNumbers = true;
        for (ColumnType type : this._columnTypes) {
            if (allStrings && !type.isLiteral()) {
                allStrings = false;
                continue;
            }
            if (!allNumbers || type.isNumber()) continue;
            allNumbers = false;
        }
        if (allStrings) {
            return ColumnType.STRING;
        }
        if (allNumbers) {
            return ColumnType.NUMBER;
        }
        return ColumnType.OTHER;
    }
}

