/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema;

public enum TableType {
    TABLE,
    VIEW,
    SYSTEM_TABLE,
    GLOBAL_TEMPORARY,
    LOCAL_TEMPORARY,
    ALIAS,
    SYNONYM,
    OTHER;

    public static final TableType[] DEFAULT_TABLE_TYPES;

    public boolean isMaterialized() {
        switch (this) {
            case TABLE: 
            case SYSTEM_TABLE: {
                return true;
            }
        }
        return false;
    }

    public static TableType getTableType(String literalType) {
        if ("TABLE".equals(literalType = literalType.toUpperCase())) {
            return TABLE;
        }
        if ("VIEW".equals(literalType)) {
            return VIEW;
        }
        if ("SYSTEM_TABLE".equals(literalType)) {
            return SYSTEM_TABLE;
        }
        if ("GLOBAL_TEMPORARY".equals(literalType)) {
            return GLOBAL_TEMPORARY;
        }
        if ("LOCAL_TEMPORARY".equals(literalType)) {
            return LOCAL_TEMPORARY;
        }
        if ("ALIAS".equals(literalType)) {
            return ALIAS;
        }
        if ("SYNONYM".equals(literalType)) {
            return SYNONYM;
        }
        return OTHER;
    }

    static {
        DEFAULT_TABLE_TYPES = new TableType[]{TABLE, VIEW};
    }
}

