/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.metamodel.schema.AbstractTable;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Relationship;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.TableType;

public class MutableTable
extends AbstractTable
implements Serializable {
    private static final long serialVersionUID = -5094888465714027354L;
    protected String _name;
    protected TableType _type;
    protected String _remarks;
    protected Schema _schema;
    protected final List<Column> _columns = new ArrayList<Column>();
    protected final List<Relationship> _relationships = new ArrayList<Relationship>();
    protected String _quoteString = null;

    public MutableTable() {
    }

    public MutableTable(String name) {
        this();
        this.setName(name);
    }

    public MutableTable(String name, TableType type) {
        this(name);
        this._type = type;
    }

    public MutableTable(String name, TableType type, Schema schema) {
        this(name, type);
        this._schema = schema;
    }

    public MutableTable(String name, TableType type, Schema schema, Column ... columns) {
        this(name, type, schema);
        this.setColumns(columns);
    }

    public MutableTable(String name, Schema schema) {
        this(name);
        this.setSchema(schema);
    }

    @Override
    public String getName() {
        return this._name;
    }

    public MutableTable setName(String name) {
        this._name = name;
        return this;
    }

    protected List<Column> getColumnsInternal() {
        return this._columns;
    }

    protected List<Relationship> getRelationshipsInternal() {
        return this._relationships;
    }

    @Override
    public List<Column> getColumns() {
        List<Column> columns = this.getColumnsInternal();
        return Collections.unmodifiableList(columns);
    }

    public MutableTable setColumns(Column ... columns) {
        this._columns.clear();
        for (Column column : columns) {
            this._columns.add(column);
        }
        return this;
    }

    public MutableTable setColumns(Collection<Column> columns) {
        this._columns.clear();
        for (Column column : columns) {
            this._columns.add(column);
        }
        return this;
    }

    public MutableTable addColumn(Column column) {
        this._columns.add(column);
        return this;
    }

    public MutableTable addColumn(int index, Column column) {
        this._columns.add(index, column);
        return this;
    }

    public MutableTable removeColumn(Column column) {
        this._columns.remove(column);
        return this;
    }

    @Override
    public Schema getSchema() {
        return this._schema;
    }

    public MutableTable setSchema(Schema schema) {
        this._schema = schema;
        return this;
    }

    @Override
    public TableType getType() {
        if (this._type == null) {
            return TableType.TABLE;
        }
        return this._type;
    }

    public MutableTable setType(TableType type) {
        this._type = type;
        return this;
    }

    public List<Relationship> getRelationships() {
        this.getRelationshipsInternal();
        return Collections.unmodifiableList(this._relationships);
    }

    protected void addRelationship(Relationship relation) {
        for (Relationship existingRelationship : this._relationships) {
            if (!existingRelationship.equals(relation)) continue;
            return;
        }
        this._relationships.add(relation);
    }

    protected MutableTable removeRelationship(Relationship relation) {
        this._relationships.remove(relation);
        return this;
    }

    @Override
    public String getRemarks() {
        return this._remarks;
    }

    public MutableTable setRemarks(String remarks) {
        this._remarks = remarks;
        return this;
    }

    @Override
    public String getQuote() {
        return this._quoteString;
    }

    public MutableTable setQuote(String quoteString) {
        this._quoteString = quoteString;
        return this;
    }
}

