/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.metamodel.schema.AbstractSchema;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;

public class MutableSchema
extends AbstractSchema
implements Serializable,
Schema {
    private static final long serialVersionUID = 4465197783868238863L;
    private String _name;
    private final List<Table> _tables = new ArrayList<Table>();

    public MutableSchema() {
    }

    public MutableSchema(String name) {
        this();
        this._name = name;
    }

    public MutableSchema(String name, Table ... tables) {
        this(name);
        this.setTables(tables);
    }

    @Override
    public String getName() {
        return this._name;
    }

    public MutableSchema setName(String name) {
        this._name = name;
        return this;
    }

    @Override
    public List<Table> getTables() {
        return Collections.unmodifiableList(this._tables);
    }

    public MutableSchema setTables(Collection<? extends Table> tables) {
        this.clearTables();
        for (Table table : tables) {
            this._tables.add(table);
        }
        return this;
    }

    public MutableSchema setTables(Table ... tables) {
        this.clearTables();
        for (Table table : tables) {
            this._tables.add(table);
        }
        return this;
    }

    public MutableSchema clearTables() {
        this._tables.clear();
        return this;
    }

    public MutableSchema addTable(Table table) {
        this._tables.add(table);
        return this;
    }

    public MutableSchema removeTable(Table table) {
        this._tables.remove(table);
        return this;
    }

    @Override
    public String getQuote() {
        return null;
    }
}

