/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.metamodel.schema.AbstractTable;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ImmutableColumn;
import org.apache.metamodel.schema.ImmutableRelationship;
import org.apache.metamodel.schema.ImmutableSchema;
import org.apache.metamodel.schema.Relationship;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.TableType;

final class ImmutableTable
extends AbstractTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<ImmutableColumn> columns = new ArrayList<ImmutableColumn>();
    private final List<ImmutableRelationship> relationships = new ArrayList<ImmutableRelationship>();
    private final ImmutableSchema schema;
    private final TableType type;
    private final String remarks;
    private final String name;
    private final String quote;

    protected ImmutableTable(String name, TableType type, ImmutableSchema schema, String remarks, String quote) {
        this.name = name;
        this.type = type;
        this.schema = schema;
        this.remarks = remarks;
        this.quote = quote;
    }

    protected ImmutableTable(Table table, ImmutableSchema schema) {
        this(table.getName(), table.getType(), schema, table.getRemarks(), table.getQuote());
        List<Column> origColumns = table.getColumns();
        for (Column column : origColumns) {
            this.columns.add(new ImmutableColumn(column, this));
        }
    }

    protected void addRelationship(ImmutableRelationship relationship) {
        if (!this.relationships.contains(relationship)) {
            this.relationships.add(relationship);
        }
    }

    @Override
    public List<Column> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public TableType getType() {
        if (this.type == null) {
            return TableType.TABLE;
        }
        return this.type;
    }

    @Override
    public Collection<Relationship> getRelationships() {
        return Collections.unmodifiableCollection(this.relationships);
    }

    @Override
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQuote() {
        return this.quote;
    }
}

