/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema;

import java.util.ArrayList;
import java.util.List;
import org.apache.metamodel.schema.AbstractSchema;
import org.apache.metamodel.schema.AliasTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.WrappingSchema;

public class DefaultTableAliasedSchema
extends AbstractSchema
implements WrappingSchema {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_TABLE_NAME = "default_table";
    private final Schema wrappedSchema;

    public static Schema wrapIfAppropriate(Schema schema) {
        if (schema.getTableCount() > 1) {
            return schema;
        }
        return new DefaultTableAliasedSchema(schema);
    }

    private static AliasTable createTable(Schema schema, Table delegateTable) {
        return new AliasTable(DEFAULT_TABLE_NAME, schema, delegateTable);
    }

    private DefaultTableAliasedSchema(Schema wrappedSchema) {
        this.wrappedSchema = wrappedSchema;
    }

    @Override
    public Schema getWrappedSchema() {
        return this.wrappedSchema;
    }

    @Override
    public String getName() {
        return this.wrappedSchema.getName();
    }

    @Override
    public List<Table> getTables() {
        List<Table> tables = this.wrappedSchema.getTables();
        if (tables.size() != 1) {
            return tables;
        }
        if (DEFAULT_TABLE_NAME.equals(tables.get(0).getName())) {
            return tables;
        }
        if (!(tables instanceof ArrayList)) {
            tables = new ArrayList<Table>(tables);
        }
        tables.add(DefaultTableAliasedSchema.createTable(this, tables.get(0)));
        return tables;
    }

    @Override
    public String getQuote() {
        return this.wrappedSchema.getQuote();
    }
}

