/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.metamodel.schema.AbstractSchema;
import org.apache.metamodel.schema.Relationship;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.TableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeSchema
extends AbstractSchema {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(CompositeSchema.class);
    private final String name;
    private final Collection<? extends Schema> delegates;

    public CompositeSchema(String name, Collection<? extends Schema> delegates) {
        this.name = name;
        this.delegates = delegates;
        if (logger.isWarnEnabled()) {
            HashSet<String> names = new HashSet<String>();
            for (Table table : this.getTables()) {
                if (names.contains(table.getName())) {
                    logger.warn("Name-clash detected for Table {}.", (Object)table.getName());
                    logger.warn("getTableByName(\"{}\") will return just the first table.", (Object)table.getName());
                    continue;
                }
                names.add(table.getName());
            }
            if (!names.isEmpty()) {
                logger.warn("The following table names clashes in composite schema: " + names);
            }
        }
    }

    public List<Relationship> getRelationships() {
        return this.delegates.stream().flatMap(delegate -> delegate.getRelationships().stream()).collect(Collectors.toList());
    }

    @Override
    public List<Table> getTables() {
        return this.delegates.stream().flatMap(delegate -> delegate.getTables().stream()).filter(table -> table.getType() != TableType.ALIAS).collect(Collectors.toList());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQuote() {
        return null;
    }
}

