/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.Relationship;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.SuperColumnType;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTable
implements Table {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractTable.class);

    @Override
    public final int getColumnCount() {
        return this.getColumns().size();
    }

    @Override
    public Column getColumn(int index) throws IndexOutOfBoundsException {
        return this.getColumns().get(index);
    }

    @Override
    public final Column getColumnByName(String columnName) {
        if (columnName == null) {
            return null;
        }
        ArrayList<Column> foundColumns = new ArrayList<Column>(1);
        for (Column column : this.getColumns()) {
            String candidateName = column.getName();
            if (!columnName.equalsIgnoreCase(candidateName)) continue;
            foundColumns.add(column);
        }
        int numColumns = foundColumns.size();
        if (logger.isDebugEnabled()) {
            logger.debug("Found {} column(s) matching '{}': {}", new Object[]{numColumns, columnName, foundColumns});
        }
        if (numColumns == 0) {
            return null;
        }
        if (numColumns == 1) {
            return (Column)foundColumns.get(0);
        }
        for (Column column : foundColumns) {
            if (!columnName.equals(column.getName())) continue;
            return column;
        }
        return (Column)foundColumns.get(0);
    }

    @Override
    public final int getRelationshipCount() {
        return this.getRelationships().size();
    }

    @Override
    public final List<Column> getNumberColumns() {
        return this.getColumnsOfSuperType(SuperColumnType.NUMBER_TYPE);
    }

    @Override
    public final List<Column> getLiteralColumns() {
        return this.getColumnsOfSuperType(SuperColumnType.LITERAL_TYPE);
    }

    @Override
    public final List<Column> getTimeBasedColumns() {
        return this.getColumnsOfSuperType(SuperColumnType.TIME_TYPE);
    }

    @Override
    public final List<Column> getBooleanColumns() {
        return this.getColumnsOfSuperType(SuperColumnType.BOOLEAN_TYPE);
    }

    @Override
    public final List<Column> getIndexedColumns() {
        return this.getColumns().stream().filter(Column::isIndexed).collect(Collectors.toList());
    }

    @Override
    public final Collection<Relationship> getForeignKeyRelationships() {
        return CollectionUtils.filter(this.getRelationships(), rel -> this.equals(rel.getForeignTable()));
    }

    public final List<Relationship> getPrimaryKeyRelationships() {
        return CollectionUtils.filter(this.getRelationships(), rel -> this.equals(rel.getPrimaryTable()));
    }

    @Override
    public final List<Column> getForeignKeys() {
        LinkedHashSet columns = new LinkedHashSet();
        Collection<Relationship> relationships = this.getForeignKeyRelationships();
        CollectionUtils.forEach(relationships, rel -> {
            List<Column> foreignColumns = rel.getForeignColumns();
            for (Column column : foreignColumns) {
                columns.add(column);
            }
        });
        return new ArrayList<Column>(columns);
    }

    @Override
    public final List<Column> getPrimaryKeys() {
        ArrayList<Column> primaryKeyColumns = new ArrayList<Column>();
        List<Column> columnsInTable = this.getColumns();
        for (Column column : columnsInTable) {
            if (!column.isPrimaryKey()) continue;
            primaryKeyColumns.add(column);
        }
        return primaryKeyColumns;
    }

    @Override
    public final List<String> getColumnNames() {
        return this.getColumns().stream().map(col -> col.getName()).collect(Collectors.toList());
    }

    @Override
    public final List<Column> getColumnsOfType(ColumnType columnType) {
        return this.getColumns().stream().filter(col -> col.getType() != null).filter(col -> col.getType().equals(columnType)).collect(Collectors.toList());
    }

    @Override
    public final List<Column> getColumnsOfSuperType(SuperColumnType superColumnType) {
        return this.getColumns().stream().filter(col -> col.getType() != null).filter(col -> col.getType().getSuperType().equals((Object)superColumnType)).collect(Collectors.toList());
    }

    @Override
    public final Collection<Relationship> getRelationships(Table otherTable) {
        Collection<Relationship> relationships = this.getRelationships();
        return CollectionUtils.filter(relationships, relation -> {
            if (relation.getForeignTable() == otherTable && relation.getPrimaryTable() == this) {
                return true;
            }
            return relation.getForeignTable() == this && relation.getPrimaryTable() == otherTable;
        });
    }

    @Override
    public final String getQuotedName() {
        String quote = this.getQuote();
        if (quote == null) {
            return this.getName();
        }
        return quote + this.getName() + quote;
    }

    @Override
    public final String getQualifiedLabel() {
        StringBuilder sb = new StringBuilder();
        Schema schema = this.getSchema();
        if (schema != null && schema.getName() != null) {
            sb.append(schema.getQualifiedLabel());
            sb.append('.');
        }
        sb.append(this.getName());
        return sb.toString();
    }

    public final String toString() {
        return "Table[name=" + this.getName() + ",type=" + (Object)((Object)this.getType()) + ",remarks=" + this.getRemarks() + "]";
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Table) {
            Table other = (Table)obj;
            if (!this.getQualifiedLabel().equals(other.getQualifiedLabel())) {
                return false;
            }
            if (this.getType() != other.getType()) {
                return false;
            }
            Schema sch1 = this.getSchema();
            Schema sch2 = other.getSchema();
            if (sch1 != null ? !sch1.equals(sch2) : sch2 != null) {
                return false;
            }
            try {
                List<String> columnNames1 = this.getColumnNames();
                List<String> columnNames2 = other.getColumnNames();
                if (columnNames1 != null && columnNames1.size() != 0 && columnNames2 != null && columnNames2.size() != 0 && !columnNames1.equals(columnNames2)) {
                    return false;
                }
            }
            catch (Exception e) {
                logger.debug("Caught (and ignoring) exception while comparing column names of tables", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    @Override
    public final int compareTo(Table that) {
        int diff = this.getQualifiedLabel().compareTo(that.getQualifiedLabel());
        if (diff == 0) {
            diff = this.toString().compareTo(that.toString());
        }
        return diff;
    }
}

