/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.schema;

import java.util.List;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Relationship;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.BaseObject;

public abstract class AbstractRelationship
extends BaseObject
implements Relationship {
    private static final long serialVersionUID = 1L;

    protected static Table checkSameTable(List<Column> columns) {
        if (columns == null || columns.size() == 0) {
            throw new IllegalArgumentException("At least one key-column must exist on both primary and foreign side for a relation to exist.");
        }
        Table table = null;
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            if (i == 0) {
                table = column.getTable();
                continue;
            }
            if (table == column.getTable()) continue;
            throw new IllegalArgumentException("Key-columns did not have same table");
        }
        return table;
    }

    @Override
    public Table getForeignTable() {
        return this.getForeignColumns().get(0).getTable();
    }

    @Override
    public Table getPrimaryTable() {
        return this.getPrimaryColumns().get(0).getTable();
    }

    @Override
    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("Relationship[");
        sb.append("primaryTable=" + this.getPrimaryTable().getName());
        List<Column> columns = this.getPrimaryColumns();
        sb.append(",primaryColumns=[");
        for (i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(columns.get(i).getName());
        }
        sb.append("]");
        sb.append(",foreignTable=" + this.getForeignTable().getName());
        columns = this.getForeignColumns();
        sb.append(",foreignColumns=[");
        for (i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(columns.get(i).getName());
        }
        sb.append("]");
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int compareTo(Relationship that) {
        return this.toString().compareTo(that.toString());
    }

    @Override
    protected final void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this.getPrimaryColumns());
        identifiers.add(this.getForeignColumns());
    }

    @Override
    protected final boolean classEquals(BaseObject obj) {
        return obj instanceof Relationship;
    }

    @Override
    public boolean containsColumnPair(Column pkColumn, Column fkColumn) {
        if (pkColumn != null && fkColumn != null) {
            List<Column> primaryColumns = this.getPrimaryColumns();
            List<Column> foreignColumns = this.getForeignColumns();
            for (int i = 0; i < primaryColumns.size(); ++i) {
                if (!pkColumn.equals(primaryColumns.get(i)) || !fkColumn.equals(foreignColumns.get(i))) continue;
                return true;
            }
        }
        return false;
    }
}

