/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.query.parser;

import java.util.Arrays;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.MetaModelHelper;
import org.apache.metamodel.query.CountAggregateFunction;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.query.FunctionType;
import org.apache.metamodel.query.FunctionTypeFactory;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.query.parser.QueryParserException;
import org.apache.metamodel.query.parser.QueryPartProcessor;
import org.apache.metamodel.schema.Column;

public final class SelectItemParser
implements QueryPartProcessor {
    private final Query _query;
    private final boolean _allowExpressionBasedSelectItems;

    public SelectItemParser(Query query, boolean allowExpressionBasedSelectItems) {
        this._query = query;
        this._allowExpressionBasedSelectItems = allowExpressionBasedSelectItems;
    }

    @Override
    public void parse(String delim, String itemToken) throws MetaModelException {
        if ("*".equals(itemToken)) {
            this._query.selectAll();
            return;
        }
        String alias = null;
        int indexOfAlias = itemToken.toUpperCase().lastIndexOf(" AS ");
        if (indexOfAlias != -1) {
            alias = itemToken.substring(indexOfAlias + " AS ".length());
            itemToken = itemToken.substring(0, indexOfAlias).trim();
        }
        try {
            SelectItem selectItem = this.findSelectItem(itemToken);
            if (selectItem == null) {
                throw new QueryParserException("Not capable of parsing SELECT token: " + itemToken);
            }
            if (alias != null) {
                selectItem.setAlias(alias);
            }
            this._query.select(selectItem);
        }
        catch (MultipleSelectItemsParsedException e) {
            FromItem fromItem = e.getFromItem();
            if (fromItem != null) {
                this._query.selectAll(fromItem);
            }
            throw e;
        }
    }

    public SelectItem findSelectItem(String expression) throws MultipleSelectItemsParsedException {
        SelectItem aliasSelectItem;
        FunctionType function;
        boolean functionApproximation;
        if ("*".equals(expression)) {
            throw new MultipleSelectItemsParsedException(null);
        }
        if ("COUNT(*)".equalsIgnoreCase(expression)) {
            return SelectItem.getCountAllItem();
        }
        String unmodifiedExpression = expression;
        T[] functionParameters = null;
        int startParenthesis = expression.indexOf(40);
        if (startParenthesis > 0 && expression.endsWith(")")) {
            functionApproximation = expression.startsWith("APPROXIMATE ");
            String functionName = expression.substring(functionApproximation ? "APPROXIMATE ".length() : 0, startParenthesis);
            function = FunctionTypeFactory.get(functionName.toUpperCase());
            if (function != null) {
                expression = expression.substring(startParenthesis + 1, expression.length() - 1).trim();
                if (function instanceof CountAggregateFunction && "*".equals(expression)) {
                    SelectItem selectItem = SelectItem.getCountAllItem();
                    selectItem.setFunctionApproximationAllowed(functionApproximation);
                    return selectItem;
                }
                String[] expressionSplit = expression.split(",");
                if (expressionSplit.length > 1) {
                    expression = expressionSplit[0].trim();
                    functionParameters = Arrays.copyOfRange(expressionSplit, 1, expressionSplit.length, String[].class);
                }
            }
        } else {
            function = null;
            functionParameters = null;
            functionApproximation = false;
        }
        String columnName = null;
        FromItem fromItem = null;
        int splitIndex = expression.lastIndexOf(46);
        while (fromItem == null && splitIndex != -1) {
            String prefix = expression.substring(0, splitIndex);
            columnName = expression.substring(splitIndex + 1);
            fromItem = this._query.getFromClause().getItemByReference(prefix);
            splitIndex = expression.lastIndexOf(46, splitIndex - 1);
        }
        if (fromItem == null) {
            if (this._query.getFromClause().getItemCount() == 1) {
                fromItem = (FromItem)this._query.getFromClause().getItem(0);
                columnName = expression;
            } else {
                fromItem = null;
                columnName = null;
            }
        }
        if (fromItem != null) {
            if ("*".equals(columnName)) {
                throw new MultipleSelectItemsParsedException(fromItem);
            }
            if (fromItem.getTable() != null) {
                Column column = fromItem.getTable().getColumnByName(columnName);
                int offset = -1;
                while (function == null && column == null && (offset = columnName.indexOf(46, offset + 1)) != -1) {
                    String part1 = columnName.substring(0, offset);
                    column = fromItem.getTable().getColumnByName(part1);
                    if (column == null) continue;
                    String part2 = columnName.substring(offset + 1);
                    return new SelectItem(FunctionType.MAP_VALUE, new Object[]{part2}, column, fromItem);
                }
                if (column != null) {
                    SelectItem selectItem = new SelectItem(function, functionParameters, column, fromItem);
                    selectItem.setFunctionApproximationAllowed(functionApproximation);
                    return selectItem;
                }
            } else if (fromItem.getSubQuery() != null) {
                Query subQuery = fromItem.getSubQuery();
                SelectItem subQuerySelectItem = new SelectItemParser(subQuery, this._allowExpressionBasedSelectItems).findSelectItem(columnName);
                if (subQuerySelectItem == null) {
                    return null;
                }
                return new SelectItem(subQuerySelectItem, fromItem);
            }
        }
        if ((aliasSelectItem = MetaModelHelper.getSelectItemByAlias(this._query, unmodifiedExpression)) != null) {
            return aliasSelectItem;
        }
        if (this._allowExpressionBasedSelectItems) {
            SelectItem selectItem = new SelectItem(function, expression, null);
            selectItem.setFunctionApproximationAllowed(functionApproximation);
            return selectItem;
        }
        return null;
    }

    public static class MultipleSelectItemsParsedException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
        private final FromItem _fromItem;

        public MultipleSelectItemsParsedException(FromItem fromItem) {
            this._fromItem = fromItem;
        }

        public FromItem getFromItem() {
            return this._fromItem;
        }
    }
}

