/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.query.builder;

import java.util.List;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.query.JoinType;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.query.builder.JoinFromBuilder;
import org.apache.metamodel.query.builder.SatisfiedFromBuilder;
import org.apache.metamodel.query.builder.SatisfiedFromBuilderCallback;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;

final class JoinFromBuilderImpl
extends SatisfiedFromBuilderCallback
implements JoinFromBuilder {
    private JoinType joinType;
    private FromItem leftItem;
    private FromItem rightItem;

    public JoinFromBuilderImpl(Query query, FromItem leftItem, Table rightTable, JoinType joinType, DataContext dataContext) {
        super(query, dataContext);
        this.joinType = joinType;
        this.leftItem = leftItem;
        this.rightItem = new FromItem(rightTable);
    }

    @Override
    public SatisfiedFromBuilder on(String left, String right) throws IllegalArgumentException {
        Table leftTable = this.leftItem.getTable();
        if (leftTable == null) {
            throw new IllegalArgumentException("Left side of join is not a Table, cannot resolve ON item: '" + left + "'.");
        }
        Table rightTable = this.rightItem.getTable();
        if (rightTable == null) {
            throw new IllegalArgumentException("Right side of join is not a Table, cannot resolve ON item: '" + right + "'.");
        }
        Column leftColumn = leftTable.getColumnByName(left);
        Column rightColumn = rightTable.getColumnByName(right);
        return this.on(leftColumn, rightColumn);
    }

    @Override
    public SatisfiedFromBuilder on(Column left, Column right) throws IllegalArgumentException {
        if (left == null) {
            throw new IllegalArgumentException("left cannot be null");
        }
        if (right == null) {
            throw new IllegalArgumentException("right cannot be null");
        }
        this.getQuery().getFromClause().removeItem(this.leftItem);
        SelectItem[] leftOn = new SelectItem[]{new SelectItem(left)};
        SelectItem[] rightOn = new SelectItem[]{new SelectItem(right)};
        FromItem fromItem = new FromItem(this.joinType, this.leftItem, this.rightItem, leftOn, rightOn);
        this.getQuery().from(fromItem);
        return this;
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add((Object)this.joinType);
        identifiers.add(this.leftItem);
        identifiers.add(this.rightItem);
    }
}

