/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.query.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.FunctionType;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.query.builder.AbstractQueryFilterBuilder;
import org.apache.metamodel.query.builder.GroupedQueryBuilder;
import org.apache.metamodel.query.builder.HavingBuilder;
import org.apache.metamodel.query.builder.SatisfiedHavingBuilder;
import org.apache.metamodel.schema.Column;

final class HavingBuilderImpl
extends AbstractQueryFilterBuilder<SatisfiedHavingBuilder>
implements HavingBuilder,
SatisfiedHavingBuilder {
    private final Query _query;
    private final List<FilterItem> _orFilters;
    private FilterItem _parentOrFilter;

    public HavingBuilderImpl(SelectItem selectItem, Query query, GroupedQueryBuilder queryBuilder) {
        super(selectItem, queryBuilder);
        this._query = query;
        this._orFilters = new ArrayList<FilterItem>();
    }

    public HavingBuilderImpl(FunctionType function, Column column, Query query, GroupedQueryBuilder queryBuilder) {
        this(new SelectItem(function, column), query, queryBuilder);
    }

    public HavingBuilderImpl(FunctionType function, Column column, Query query, FilterItem parentOrFilter, List<FilterItem> orFilters, GroupedQueryBuilder queryBuilder) {
        this(function, column, query, queryBuilder);
    }

    @Override
    protected SatisfiedHavingBuilder applyFilter(FilterItem filter) {
        if (this._parentOrFilter == null) {
            this._query.having(filter);
        } else if (this._parentOrFilter.getChildItemCount() == 1) {
            this._query.getHavingClause().removeItem(this._orFilters.get(0));
            this._query.getHavingClause().addItem(this._parentOrFilter);
        }
        this._orFilters.add(filter);
        return this;
    }

    @Override
    public HavingBuilder or(FunctionType function, Column column) {
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        if (column == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        if (this._parentOrFilter == null) {
            this._parentOrFilter = new FilterItem(this._orFilters);
        }
        return new HavingBuilderImpl(function, column, this._query, this._parentOrFilter, this._orFilters, this.getQueryBuilder());
    }

    @Override
    public HavingBuilder and(FunctionType function, Column column) {
        return this.getQueryBuilder().having(function, column);
    }
}

