/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.query;

import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.DefaultScalarFunction;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.util.BooleanComparator;

public class ToBooleanFunction
extends DefaultScalarFunction {
    private static final long serialVersionUID = 1L;

    @Override
    public ColumnType getExpectedColumnType(ColumnType type) {
        if (type.isBoolean()) {
            return type;
        }
        return ColumnType.BOOLEAN;
    }

    @Override
    public String getFunctionName() {
        return "TO_BOOLEAN";
    }

    @Override
    public Object evaluate(Row row, Object[] parameters, SelectItem item) {
        Object value = row.getValue(item);
        if (value == null || value instanceof Boolean) {
            return value;
        }
        return BooleanComparator.toBoolean(value);
    }
}

