/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.query;

import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.FunctionType;
import org.apache.metamodel.query.ScalarFunction;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.util.NumberComparator;

public class SubstringFunction
implements ScalarFunction {
    private static final long serialVersionUID = 1L;
    private final boolean oneBased;
    private final boolean secondParamIsCharCount;

    public static SubstringFunction createSqlStyle() {
        return new SubstringFunction(true, true);
    }

    public static SubstringFunction createJavaStyle() {
        return new SubstringFunction(false, false);
    }

    public SubstringFunction(boolean oneBased, boolean secondParamIsCharCount) {
        this.oneBased = oneBased;
        this.secondParamIsCharCount = secondParamIsCharCount;
    }

    @Override
    public ColumnType getExpectedColumnType(ColumnType type) {
        return ColumnType.STRING;
    }

    @Override
    public String getFunctionName() {
        if (!this.oneBased && !this.secondParamIsCharCount) {
            return "JAVA_SUBSTRING";
        }
        return "SUBSTRING";
    }

    @Override
    public Object evaluate(Row row, Object[] parameters, SelectItem operandItem) {
        String str = (String)FunctionType.TO_STRING.evaluate(row, null, operandItem);
        if (str == null) {
            return null;
        }
        int numParameters = parameters == null ? 0 : parameters.length;
        switch (numParameters) {
            case 0: {
                return str;
            }
            case 1: {
                int begin = this.toInt(parameters[0]);
                if (this.oneBased) {
                    --begin;
                }
                if (begin >= str.length()) {
                    return "";
                }
                return str.substring(begin);
            }
        }
        int from = this.toInt(parameters[0]);
        if (this.oneBased) {
            --from;
        }
        int to = this.toInt(parameters[1]);
        if (this.secondParamIsCharCount) {
            to = from + to;
        } else if (this.oneBased) {
            --to;
        }
        if (from >= str.length() || from > to) {
            return "";
        }
        if (to >= str.length()) {
            return str.substring(from);
        }
        return str.substring(from, to);
    }

    private int toInt(Object parameter) {
        Number number = NumberComparator.toNumber(parameter);
        if (number == null) {
            throw new IllegalArgumentException("Not a valid substring parameter: " + parameter);
        }
        return Math.max(0, number.intValue());
    }
}

