/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.query;

import java.util.List;
import org.apache.metamodel.query.AggregateFunction;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.query.FunctionType;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.QueryItem;
import org.apache.metamodel.query.ScalarFunction;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.util.BaseObject;
import org.apache.metamodel.util.EqualsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectItem
extends BaseObject
implements QueryItem,
Cloneable {
    public static final String FUNCTION_APPROXIMATION_PREFIX = "APPROXIMATE ";
    private static final long serialVersionUID = 317475105509663973L;
    private static final Logger logger = LoggerFactory.getLogger(SelectItem.class);
    private final Column _column;
    private final FunctionType _function;
    private final Object[] _functionParameters;
    private final String _expression;
    private final SelectItem _subQuerySelectItem;
    private final FromItem _fromItem;
    private boolean _functionApproximationAllowed;
    private Query _query;
    private String _alias;

    private SelectItem(Column column, FromItem fromItem, FunctionType function, Object[] functionParameters, String expression, SelectItem subQuerySelectItem, String alias, boolean functionApproximationAllowed) {
        this._column = column;
        this._fromItem = fromItem;
        this._function = function;
        this._functionParameters = functionParameters != null && functionParameters.length == 0 ? null : functionParameters;
        this._expression = expression;
        this._subQuerySelectItem = subQuerySelectItem;
        this._alias = alias;
        this._functionApproximationAllowed = functionApproximationAllowed;
    }

    public static SelectItem getCountAllItem() {
        return new SelectItem((FunctionType)FunctionType.COUNT, "*", null);
    }

    public static boolean isCountAllItem(SelectItem item) {
        return item != null && item.getAggregateFunction() != null && item.getAggregateFunction().toString().equals("COUNT") && item.getExpression() == "*";
    }

    public SelectItem(Column column) {
        this(null, column);
    }

    public SelectItem(FunctionType function, Column column) {
        this(function, column, null);
    }

    public SelectItem(FunctionType function, Object[] functionParameters, Column column) {
        this(function, functionParameters, column, null);
    }

    public SelectItem(Column column, FromItem fromItem) {
        this(null, column, fromItem);
        Table columnTable;
        Table fromItemTable;
        if (fromItem != null && (fromItemTable = fromItem.getTable()) != null && fromItemTable.getType() != TableType.ALIAS && (columnTable = column.getTable()) != null && !columnTable.equals(fromItemTable)) {
            throw new IllegalArgumentException("Column's table '" + columnTable.getName() + "' is not equal to referenced table: " + fromItemTable);
        }
    }

    public SelectItem(FunctionType function, Column column, FromItem fromItem) {
        this(column, fromItem, function, null, null, null, null, false);
        if (column == null) {
            throw new IllegalArgumentException("column=null");
        }
    }

    public SelectItem(FunctionType function, Object[] functionParameters, Column column, FromItem fromItem) {
        this(column, fromItem, function, functionParameters, null, null, null, false);
        if (column == null) {
            throw new IllegalArgumentException("column=null");
        }
    }

    public SelectItem(String expression, String alias) {
        this(null, expression, alias);
    }

    public SelectItem(FunctionType function, String expression, String alias) {
        this(null, null, function, null, expression, null, alias, false);
        if (expression == null) {
            throw new IllegalArgumentException("expression=null");
        }
    }

    public SelectItem(SelectItem subQuerySelectItem, FromItem subQueryFromItem) {
        this(null, subQueryFromItem, null, null, null, subQuerySelectItem, null, false);
        if (subQueryFromItem.getSubQuery() == null) {
            throw new IllegalArgumentException("Only sub-query based FromItems allowed.");
        }
        if (subQuerySelectItem.getQuery() != null && !subQuerySelectItem.getQuery().equals(subQueryFromItem.getSubQuery())) {
            throw new IllegalArgumentException("The SelectItem must exist in the sub-query");
        }
    }

    public String getAlias() {
        return this._alias;
    }

    public SelectItem setAlias(String alias) {
        this._alias = alias;
        return this;
    }

    public boolean hasFunction() {
        return this._function != null;
    }

    public AggregateFunction getAggregateFunction() {
        if (this._function instanceof AggregateFunction) {
            return (AggregateFunction)this._function;
        }
        return null;
    }

    public ScalarFunction getScalarFunction() {
        if (this._function instanceof ScalarFunction) {
            return (ScalarFunction)this._function;
        }
        return null;
    }

    public Object[] getFunctionParameters() {
        return this._functionParameters;
    }

    public boolean isFunctionApproximationAllowed() {
        return this._functionApproximationAllowed;
    }

    public void setFunctionApproximationAllowed(boolean functionApproximationAllowed) {
        this._functionApproximationAllowed = functionApproximationAllowed;
    }

    public Column getColumn() {
        return this._column;
    }

    public ColumnType getExpectedColumnType() {
        if (this._subQuerySelectItem != null) {
            return this._subQuerySelectItem.getExpectedColumnType();
        }
        if (this._function != null) {
            if (this._column != null) {
                return this._function.getExpectedColumnType(this._column.getType());
            }
            return this._function.getExpectedColumnType(null);
        }
        if (this._column != null) {
            return this._column.getType();
        }
        return null;
    }

    public String getExpression() {
        return this._expression;
    }

    @Override
    public SelectItem setQuery(Query query) {
        this._query = query;
        return this;
    }

    @Override
    public Query getQuery() {
        return this._query;
    }

    public SelectItem getSubQuerySelectItem() {
        return this._subQuerySelectItem;
    }

    public FromItem getFromItem() {
        return this._fromItem;
    }

    public String getSuperQueryAlias() {
        return this.getSuperQueryAlias(true);
    }

    public String getSuperQueryAlias(boolean includeQuotes) {
        if (this._alias != null) {
            return this._alias;
        }
        if (this._column != null) {
            StringBuilder sb = new StringBuilder();
            if (includeQuotes) {
                sb.append(this._column.getQuotedName());
            } else {
                sb.append(this._column.getName());
            }
            this.appendFunctionSql(sb);
            return sb.toString();
        }
        logger.debug("Could not resolve a reasonable super-query alias for SelectItem: {}", (Object)this.toSql());
        return this.toStringNoAlias().toString();
    }

    public String getSameQueryAlias() {
        return this.getSameQueryAlias(false);
    }

    public String getSameQueryAlias(boolean includeSchemaInColumnPath) {
        if (this._column != null) {
            StringBuilder sb = new StringBuilder();
            String columnPrefix = this.getToStringColumnPrefix(includeSchemaInColumnPath);
            sb.append(columnPrefix);
            sb.append(this._column.getQuotedName());
            this.appendFunctionSql(sb);
            return sb.toString();
        }
        String alias = this.getAlias();
        if (alias == null) {
            String result = this.toStringNoAlias(includeSchemaInColumnPath).toString();
            logger.debug("Could not resolve a reasonable same-query alias for SelectItem: {}", (Object)result);
            return result;
        }
        return alias;
    }

    @Override
    public String toSql() {
        return this.toSql(false);
    }

    @Override
    public String toSql(boolean includeSchemaInColumnPath) {
        StringBuilder sb = this.toStringNoAlias(includeSchemaInColumnPath);
        if (this._alias != null) {
            sb.append(" AS ");
            sb.append(this._alias);
        }
        return sb.toString();
    }

    public StringBuilder toStringNoAlias() {
        return this.toStringNoAlias(false);
    }

    public StringBuilder toStringNoAlias(boolean includeSchemaInColumnPath) {
        StringBuilder sb = new StringBuilder();
        if (this._column != null) {
            sb.append(this.getToStringColumnPrefix(includeSchemaInColumnPath));
            sb.append(this._column.getQuotedName());
        }
        if (this._expression != null) {
            sb.append(this._expression);
        }
        if (this._fromItem != null && this._subQuerySelectItem != null) {
            if (this._fromItem.getAlias() != null) {
                sb.append(this._fromItem.getAlias() + '.');
            }
            sb.append(this._subQuerySelectItem.getSuperQueryAlias());
        }
        this.appendFunctionSql(sb);
        return sb;
    }

    private void appendFunctionSql(StringBuilder sb) {
        if (this._function == null) {
            return;
        }
        StringBuilder functionBeginning = new StringBuilder();
        if (this._functionApproximationAllowed) {
            functionBeginning.append(FUNCTION_APPROXIMATION_PREFIX);
        }
        functionBeginning.append(this._function.getFunctionName());
        functionBeginning.append('(');
        sb.insert(0, functionBeginning.toString());
        Object[] functionParameters = this.getFunctionParameters();
        if (functionParameters != null && functionParameters.length != 0) {
            for (int i = 0; i < functionParameters.length; ++i) {
                sb.append(',');
                sb.append('\'');
                sb.append(functionParameters[i]);
                sb.append('\'');
            }
        }
        sb.append(")");
    }

    private String getToStringColumnPrefix(boolean includeSchemaInColumnPath) {
        if (this._fromItem != null && this._fromItem.getAlias() != null) {
            return this._fromItem.getAlias() + '.';
        }
        Table table = this._fromItem != null && this._fromItem.getTable() != null ? this._fromItem.getTable() : this._column.getTable();
        if (table == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String tableLabel = this._query == null ? null : this._query.getFromClause().getAlias(table);
        if (tableLabel == null) {
            Schema schema;
            tableLabel = table.getQuotedName();
            if (includeSchemaInColumnPath && (schema = table.getSchema()) != null) {
                sb.append(schema.getQuotedName() + ".");
            }
        }
        sb.append(tableLabel);
        sb.append('.');
        return sb.toString();
    }

    public boolean equalsIgnoreAlias(SelectItem that) {
        return this.equalsIgnoreAlias(that, false);
    }

    public boolean equalsIgnoreAlias(SelectItem that, boolean exactColumnCompare) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        EqualsBuilder eb = new EqualsBuilder();
        if (exactColumnCompare) {
            eb.append(this._column == that._column);
            eb.append(this._fromItem, that._fromItem);
        } else {
            eb.append(this._column, that._column);
        }
        eb.append(this._function, that._function);
        eb.appendArrays(this._functionParameters, that._functionParameters);
        eb.append(this._functionApproximationAllowed, that._functionApproximationAllowed);
        eb.append(this._expression, that._expression);
        if (this._subQuerySelectItem != null) {
            eb.append(this._subQuerySelectItem.equalsIgnoreAlias(that._subQuerySelectItem));
        } else if (that._subQuerySelectItem != null) {
            eb.append(false);
        }
        return eb.isEquals();
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._expression);
        identifiers.add(this._alias);
        identifiers.add(this._column);
        identifiers.add(this._function);
        identifiers.add(this._functionParameters);
        identifiers.add(this._functionApproximationAllowed);
        if (this._fromItem == null && this._column != null && this._column.getTable() != null) {
            identifiers.add(new FromItem(this._column.getTable()));
        } else {
            identifiers.add(this._fromItem);
        }
        identifiers.add(this._subQuerySelectItem);
    }

    protected SelectItem clone() {
        return this.clone(null);
    }

    protected SelectItem clone(Query clonedQuery) {
        int indexOfFromItem;
        SelectItem subQuerySelectItem;
        SelectItem selectItem = subQuerySelectItem = this._subQuerySelectItem == null ? null : this._subQuerySelectItem.clone();
        FromItem fromItem = this._fromItem == null ? null : (clonedQuery != null && this._query != null ? ((indexOfFromItem = this._query.getFromClause().indexOf(this._fromItem)) != -1 ? (FromItem)clonedQuery.getFromClause().getItem(indexOfFromItem) : this._fromItem.clone()) : this._fromItem.clone());
        SelectItem s = new SelectItem(this._column, fromItem, this._function, this._functionParameters, this._expression, subQuerySelectItem, this._alias, this._functionApproximationAllowed);
        return s;
    }

    public SelectItem replaceFunction(FunctionType function) {
        return this.replaceFunction(function, new Object[0]);
    }

    public SelectItem replaceFunction(FunctionType function, Object ... functionParameters) {
        return new SelectItem(this._column, this._fromItem, function, functionParameters, this._expression, this._subQuerySelectItem, this._alias, this._functionApproximationAllowed);
    }

    public SelectItem replaceFunctionApproximationAllowed(boolean functionApproximationAllowed) {
        return new SelectItem(this._column, this._fromItem, this._function, this._functionParameters, this._expression, this._subQuerySelectItem, this._alias, functionApproximationAllowed);
    }

    public boolean isReferenced(Column column) {
        if (column != null) {
            if (column.equals(this._column)) {
                return true;
            }
            if (this._subQuerySelectItem != null) {
                return this._subQuerySelectItem.isReferenced(column);
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return this.toSql();
    }
}

