/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.query;

import java.util.Objects;
import org.apache.metamodel.query.OperatorType;

public class OperatorTypeImpl
implements OperatorType {
    private static final long serialVersionUID = 1L;
    private final String _sql;
    private final boolean _spaceDelimited;

    public OperatorTypeImpl(String sql, boolean spaceDelimited) {
        this._sql = sql;
        this._spaceDelimited = spaceDelimited;
    }

    @Override
    public boolean isSpaceDelimited() {
        return this._spaceDelimited;
    }

    @Override
    public String toSql() {
        return this._sql;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof OperatorType) {
            OperatorType other = (OperatorType)obj;
            return this.isSpaceDelimited() == other.isSpaceDelimited() && Objects.equals(this.toSql(), other.toSql());
        }
        return false;
    }

    public static OperatorType convertOperatorType(String sqlType) {
        if (sqlType != null) {
            switch (sqlType = sqlType.trim().toUpperCase()) {
                case "=": 
                case "==": 
                case "EQ": 
                case "EQUALS_TO": {
                    return OperatorType.EQUALS_TO;
                }
                case "<>": 
                case "!=": 
                case "NE": 
                case "NOT_EQUAL": 
                case "NOT_EQUAL_TO": 
                case "NOT_EQUALS": 
                case "NOT_EQUALS_TO": 
                case "DIFFERENT_FROM": {
                    return OperatorType.DIFFERENT_FROM;
                }
                case ">": 
                case "GT": 
                case "GREATER_THAN": {
                    return OperatorType.GREATER_THAN;
                }
                case ">=": 
                case "=>": 
                case "GREATER_THAN_OR_EQUAL": {
                    return OperatorType.GREATER_THAN_OR_EQUAL;
                }
                case "NOT_IN": 
                case "NOT IN": {
                    return OperatorType.NOT_IN;
                }
                case "IN": {
                    return OperatorType.IN;
                }
                case "<": 
                case "LT": 
                case "LESS_THAN": {
                    return OperatorType.LESS_THAN;
                }
                case "<=": 
                case "=<": 
                case "LESS_THAN_OR_EQUAL": {
                    return OperatorType.LESS_THAN_OR_EQUAL;
                }
                case "LIKE": {
                    return OperatorType.LIKE;
                }
                case "NOT_LIKE": 
                case "NOT LIKE": {
                    return OperatorType.NOT_LIKE;
                }
            }
        }
        return null;
    }
}

