/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.QueryClause;
import org.apache.metamodel.query.QueryItem;
import org.apache.metamodel.util.BaseObject;

public abstract class AbstractQueryClause<E extends QueryItem>
extends BaseObject
implements QueryClause<E> {
    private static final long serialVersionUID = 3987346267433022231L;
    public static final String PREFIX_SELECT = "SELECT ";
    public static final String PREFIX_FROM = " FROM ";
    public static final String PREFIX_WHERE = " WHERE ";
    public static final String PREFIX_GROUP_BY = " GROUP BY ";
    public static final String PREFIX_HAVING = " HAVING ";
    public static final String PREFIX_ORDER_BY = " ORDER BY ";
    public static final String DELIM_COMMA = ", ";
    public static final String DELIM_AND = " AND ";
    private final Query _query;
    private final List<E> _items = new ArrayList();
    private final String _prefix;
    private final String _delim;

    public AbstractQueryClause(Query query, String prefix, String delim) {
        this._query = query;
        this._prefix = prefix;
        this._delim = delim;
    }

    @Override
    public QueryClause<E> setItems(E ... items) {
        this._items.clear();
        return this.addItems((QueryItem[])items);
    }

    @Override
    public QueryClause<E> addItems(E ... items) {
        for (E item : items) {
            this.addItem(item);
        }
        return this;
    }

    @Override
    public QueryClause<E> addItems(Iterable<E> items) {
        for (QueryItem item : items) {
            this.addItem((E)item);
        }
        return this;
    }

    @Override
    public QueryClause<E> addItem(int index, E item) {
        if (item.getQuery() == null) {
            item.setQuery(this._query);
        }
        this._items.add(index, item);
        return this;
    }

    @Override
    public QueryClause<E> addItem(E item) {
        return this.addItem(this.getItemCount(), item);
    }

    @Override
    public int getItemCount() {
        return this._items.size();
    }

    @Override
    public int indexOf(E item) {
        return this._items.indexOf(item);
    }

    @Override
    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    @Override
    public E getItem(int index) {
        return (E)((QueryItem)this._items.get(index));
    }

    @Override
    public List<E> getItems() {
        return this._items;
    }

    @Override
    public QueryClause<E> removeItem(int index) {
        this._items.remove(index);
        return this;
    }

    @Override
    public QueryClause<E> removeItem(E item) {
        this._items.remove(item);
        return this;
    }

    @Override
    public QueryClause<E> removeItems() {
        this._items.clear();
        return this;
    }

    @Override
    public String toSql() {
        return this.toSql(false);
    }

    @Override
    public String toSql(boolean includeSchemaInColumnPaths) {
        if (this._items.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(this._prefix);
        for (int i = 0; i < this._items.size(); ++i) {
            QueryItem item = (QueryItem)this._items.get(i);
            if (i != 0) {
                sb.append(this._delim);
            }
            String sql = item.toSql(includeSchemaInColumnPaths);
            sb.append(sql);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toSql();
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._items);
    }
}

