/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.factory;

import java.net.MalformedURLException;
import java.net.URI;
import org.apache.metamodel.factory.ResourceFactory;
import org.apache.metamodel.factory.ResourceProperties;
import org.apache.metamodel.factory.UnsupportedResourcePropertiesException;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.UrlResource;

public class UrlResourceFactory
implements ResourceFactory {
    @Override
    public boolean accepts(ResourceProperties properties) {
        URI uri = properties.getUri();
        switch (uri.getScheme()) {
            case "http": 
            case "https": {
                return true;
            }
        }
        return false;
    }

    @Override
    public Resource create(ResourceProperties properties) throws UnsupportedResourcePropertiesException {
        try {
            return new UrlResource(properties.getUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new UnsupportedResourcePropertiesException(e);
        }
    }
}

