/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.metamodel.factory.ResourceFactory;
import org.apache.metamodel.factory.ResourceFactoryRegistry;
import org.apache.metamodel.factory.ResourceProperties;
import org.apache.metamodel.factory.UnsupportedResourcePropertiesException;
import org.apache.metamodel.util.Resource;

public class ResourceFactoryRegistryImpl
implements ResourceFactoryRegistry {
    private static final ResourceFactoryRegistry DEFAULT_INSTANCE;
    private final List<ResourceFactory> factories = new ArrayList<ResourceFactory>();

    public static ResourceFactoryRegistry getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    @Override
    public void addFactory(ResourceFactory factory) {
        this.factories.add(factory);
    }

    @Override
    public void clearFactories() {
        this.factories.clear();
    }

    @Override
    public Collection<ResourceFactory> getFactories() {
        return Collections.unmodifiableList(this.factories);
    }

    @Override
    public Resource createResource(ResourceProperties properties) {
        for (ResourceFactory factory : this.factories) {
            if (!factory.accepts(properties)) continue;
            return factory.create(properties);
        }
        throw new UnsupportedResourcePropertiesException();
    }

    public void discoverFromClasspath() {
        ServiceLoader<ResourceFactory> serviceLoader = ServiceLoader.load(ResourceFactory.class);
        for (ResourceFactory factory : serviceLoader) {
            this.addFactory(factory);
        }
    }

    static {
        ResourceFactoryRegistryImpl registry = new ResourceFactoryRegistryImpl();
        registry.discoverFromClasspath();
        DEFAULT_INSTANCE = registry;
    }
}

