/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.data;

import java.util.List;
import org.apache.metamodel.data.AbstractRow;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.ScalarFunctionDataSet;
import org.apache.metamodel.data.Style;
import org.apache.metamodel.query.SelectItem;

final class ScalarFunctionRow
extends AbstractRow {
    private static final long serialVersionUID = 1L;
    private final ScalarFunctionDataSet _scalarFunctionDataSet;
    private final Row _row;

    public ScalarFunctionRow(ScalarFunctionDataSet scalarFunctionDataSet, Row row) {
        this._scalarFunctionDataSet = scalarFunctionDataSet;
        this._row = row;
    }

    @Override
    public Object getValue(int index) throws IndexOutOfBoundsException {
        List<SelectItem> scalarFunctionSelectItems = this._scalarFunctionDataSet.getScalarFunctionSelectItemsToEvaluate();
        int scalarFunctionCount = scalarFunctionSelectItems.size();
        if (index >= scalarFunctionCount) {
            return this._row.getValue(index - scalarFunctionCount);
        }
        SelectItem selectItem = scalarFunctionSelectItems.get(index);
        SelectItem selectItemWithoutFunction = selectItem.replaceFunction(null);
        return selectItem.getScalarFunction().evaluate(this._row, selectItem.getFunctionParameters(), selectItemWithoutFunction);
    }

    @Override
    public Style getStyle(int index) throws IndexOutOfBoundsException {
        List<SelectItem> scalarFunctionSelectItems = this._scalarFunctionDataSet.getScalarFunctionSelectItemsToEvaluate();
        int scalarFunctionCount = scalarFunctionSelectItems.size();
        if (index >= scalarFunctionCount) {
            this._row.getStyle(index - scalarFunctionCount);
        }
        return Style.NO_STYLE;
    }

    @Override
    protected DataSetHeader getHeader() {
        return this._scalarFunctionDataSet.getHeader();
    }
}

