/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.data;

import java.io.Closeable;
import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.RowPublisher;
import org.apache.metamodel.data.RowPublisherImpl;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.util.Action;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.SharedExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RowPublisherDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger(RowPublisherDataSet.class);
    private final int _maxRows;
    private final Action<RowPublisher> _publishAction;
    private final Closeable[] _closeables;
    private RowPublisherImpl _rowPublisher;
    private boolean _closed;

    public RowPublisherDataSet(SelectItem[] selectItems, int maxRows, Action<RowPublisher> publishAction) {
        this(selectItems, maxRows, publishAction, new Closeable[0]);
    }

    public RowPublisherDataSet(SelectItem[] selectItems, int maxRows, Action<RowPublisher> publishAction, Closeable ... closeables) {
        super(selectItems);
        this._maxRows = maxRows;
        this._publishAction = publishAction;
        this._closed = false;
        this._closeables = closeables;
    }

    public int getMaxRows() {
        return this._maxRows;
    }

    @Override
    public void close() {
        super.close();
        this._closed = true;
        if (this._rowPublisher != null) {
            this._rowPublisher.finished();
            this._rowPublisher = null;
        }
        if (this._closeables != null) {
            FileHelper.safeClose(this._closeables);
        }
    }

    protected void finalize() throws Throwable {
        if (!this._closed) {
            logger.warn("finalize() invoked, but DataSet is not closed. Invoking close() on {}", (Object)this);
            this.close();
        }
    }

    @Override
    public boolean next() {
        if (this._rowPublisher == null) {
            this._rowPublisher = new RowPublisherImpl(this);
            logger.info("Starting separate thread for publishing action: {}", this._publishAction);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    boolean successful = false;
                    try {
                        RowPublisherDataSet.this._publishAction.run(RowPublisherDataSet.this._rowPublisher);
                        logger.debug("Publishing action finished!");
                        successful = true;
                    }
                    catch (Exception e) {
                        RowPublisherDataSet.this._rowPublisher.failed(e);
                    }
                    if (successful) {
                        RowPublisherDataSet.this._rowPublisher.finished();
                    }
                }
            };
            SharedExecutorService.get().submit(runnable);
        }
        return this._rowPublisher.next();
    }

    @Override
    public Row getRow() {
        if (this._rowPublisher == null) {
            return null;
        }
        return this._rowPublisher.getRow();
    }
}

