/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.data;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;

public final class CachingDataSetHeader
extends SimpleDataSetHeader
implements DataSetHeader {
    private static final long serialVersionUID = 1L;
    private transient Map<Integer, Integer> _selectItemIndexCache;
    private transient Map<Integer, Integer> _columnIndexCache;

    public CachingDataSetHeader(List<SelectItem> items) {
        super(items);
    }

    @Override
    public int indexOf(Column column) {
        int identityCode;
        Integer index;
        if (column == null) {
            return -1;
        }
        if (this._columnIndexCache == null) {
            this._columnIndexCache = new ConcurrentHashMap<Integer, Integer>(super.size());
        }
        if ((index = this._columnIndexCache.get(identityCode = System.identityHashCode(column))) == null && (index = Integer.valueOf(super.indexOf(column))) != -1) {
            this._columnIndexCache.put(identityCode, index);
        }
        return index;
    }

    @Override
    public final int indexOf(SelectItem item) {
        int identityCode;
        Integer index;
        if (item == null) {
            return -1;
        }
        if (this._selectItemIndexCache == null) {
            this._selectItemIndexCache = new ConcurrentHashMap<Integer, Integer>(super.size());
        }
        if ((index = this._selectItemIndexCache.get(identityCode = System.identityHashCode(item))) == null && (index = Integer.valueOf(super.indexOf(item))) != -1) {
            this._selectItemIndexCache.put(identityCode, index);
        }
        return index;
    }
}

