/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.convert;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Function;
import org.apache.metamodel.convert.TypeConverter;
import org.apache.metamodel.util.TimeComparator;

public class StringToDateConverter
implements TypeConverter<String, Date> {
    private final Function<Date, String> _serializeFunc;
    private final Function<String, Date> _deserializeFunc;

    public StringToDateConverter() {
        this._deserializeFunc = stringValue -> TimeComparator.toDate(stringValue);
        this._serializeFunc = date -> DateFormat.getDateTimeInstance(2, 2).format((Date)date);
    }

    public StringToDateConverter(String datePattern) {
        this(new SimpleDateFormat(datePattern));
    }

    public StringToDateConverter(DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new IllegalArgumentException("DateFormat cannot be null");
        }
        this._deserializeFunc = string -> {
            try {
                return dateFormat.parse((String)string);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Could not parse date string: " + string);
            }
        };
        this._serializeFunc = date -> dateFormat.format((Date)date);
    }

    @Override
    public String toPhysicalValue(Date virtualValue) {
        if (virtualValue == null) {
            return null;
        }
        return this._serializeFunc.apply(virtualValue);
    }

    @Override
    public Date toVirtualValue(String physicalValue) {
        if (physicalValue == null || physicalValue.length() == 0) {
            return null;
        }
        return this._deserializeFunc.apply(physicalValue);
    }
}

