/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.metamodel.AbstractDataContext;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.MetaModelHelper;
import org.apache.metamodel.annotations.InterfaceStability;
import org.apache.metamodel.convert.ConvertedDataSetInterceptor;
import org.apache.metamodel.convert.HasReadTypeConverters;
import org.apache.metamodel.convert.TypeConverter;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.EmptyDataSet;
import org.apache.metamodel.data.FirstRowDataSet;
import org.apache.metamodel.data.InMemoryDataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.query.GroupByItem;
import org.apache.metamodel.query.JoinType;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.OrderByItem;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.ScalarFunction;
import org.apache.metamodel.query.SelectClause;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.DefaultTableAliasedSchema;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableRelationship;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Relationship;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public abstract class QueryPostprocessDataContext
extends AbstractDataContext
implements HasReadTypeConverters {
    private static final Logger logger = LoggerFactory.getLogger(QueryPostprocessDataContext.class);
    public static final String SYSTEM_PROPERTY_CREATE_DEFAULT_TABLE_ALIAS = "metamodel.alias.default.table";
    public static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private final Map<Column, TypeConverter<?, ?>> converters;
    private final boolean singleTableDatastore;

    public QueryPostprocessDataContext() {
        this(true);
    }

    public QueryPostprocessDataContext(boolean singleTableDatastore) {
        this.singleTableDatastore = singleTableDatastore;
        this.converters = new HashMap();
    }

    @Override
    public DataSet executeQuery(Query query) {
        FromItem fromItem;
        Table table;
        boolean noGrouping;
        int maxRows;
        List<SelectItem> selectItems = query.getSelectClause().getItems();
        List fromItems = query.getFromClause().getItems();
        List<FilterItem> whereItems = query.getWhereClause().getItems();
        List<SelectItem> whereSelectItems = query.getWhereClause().getEvaluatedSelectItems();
        List<GroupByItem> groupByItems = query.getGroupByClause().getItems();
        List<SelectItem> groupBySelectItems = query.getGroupByClause().getEvaluatedSelectItems();
        List<SelectItem> havingSelectItems = query.getHavingClause().getEvaluatedSelectItems();
        List<SelectItem> orderBySelectItems = query.getOrderByClause().getEvaluatedSelectItems();
        List<FilterItem> havingItems = query.getHavingClause().getItems();
        List<OrderByItem> orderByItems = query.getOrderByClause().getItems();
        int firstRow = query.getFirstRow() == null ? 1 : query.getFirstRow();
        int n = maxRows = query.getMaxRows() == null ? -1 : query.getMaxRows();
        if (maxRows == 0) {
            return new EmptyDataSet(selectItems);
        }
        boolean singleFromItem = fromItems.size() == 1;
        boolean bl = noGrouping = groupByItems.isEmpty() && havingItems.isEmpty();
        if (singleFromItem && noGrouping && (table = MetaModelHelper.resolveTable(fromItem = (FromItem)query.getFromClause().getItem(0))) != null) {
            boolean isSimpleSelect;
            SelectItem selectItem;
            if (selectItems.size() == 1 && SelectItem.isCountAllItem(selectItem = (SelectItem)query.getSelectClause().getItem(0))) {
                boolean functionApproximationAllowed = selectItem.isFunctionApproximationAllowed();
                if (this.isMainSchemaTable(table)) {
                    logger.debug("Query is a COUNT query with {} where items. Trying executeCountQuery(...)", (Object)whereItems.size());
                    Number count = this.executeCountQuery(table, whereItems, functionApproximationAllowed);
                    if (count == null) {
                        logger.debug("DataContext did not return any count query results. Proceeding with manual counting.");
                    } else {
                        ArrayList<Row> data = new ArrayList<Row>(1);
                        SimpleDataSetHeader header = new SimpleDataSetHeader(new SelectItem[]{selectItem});
                        data.add(new DefaultRow(header, new Object[]{count}));
                        return new InMemoryDataSet((DataSetHeader)header, data);
                    }
                }
            }
            if (isSimpleSelect = this.isSimpleSelect(query.getSelectClause())) {
                if (whereItems.size() == 1) {
                    Column column;
                    FilterItem whereItem = (FilterItem)whereItems.get(0);
                    SelectItem selectItem2 = whereItem.getSelectItem();
                    if (!whereItem.isCompoundFilter() && selectItem2 != null && !selectItem2.hasFunction() && selectItem2.getColumn() != null && (column = selectItem2.getColumn()).isPrimaryKey() && OperatorType.EQUALS_TO.equals(whereItem.getOperator())) {
                        logger.debug("Query is a primary key lookup query. Trying executePrimaryKeyLookupQuery(...)");
                        if (table != null && this.isMainSchemaTable(table)) {
                            Object operand = whereItem.getOperand();
                            Row row = this.executePrimaryKeyLookupQuery(table, selectItems, column, operand);
                            if (row == null) {
                                logger.debug("DataContext did not return any GET query results. Proceeding with manual lookup.");
                            } else {
                                SimpleDataSetHeader header = new SimpleDataSetHeader(selectItems);
                                return new InMemoryDataSet((DataSetHeader)header, row);
                            }
                        }
                    }
                }
                if (orderByItems.isEmpty()) {
                    DataSet dataSet = this.materializeTable(table, selectItems, whereItems, firstRow, maxRows);
                    return dataSet;
                }
            }
        }
        List<SelectItem> workSelectItems = CollectionUtils.concat(true, selectItems, whereSelectItems, groupBySelectItems, havingSelectItems, orderBySelectItems);
        DataSet[] fromDataSets = new DataSet[fromItems.size()];
        for (int i = 0; i < fromDataSets.length; ++i) {
            FromItem fromItem2 = (FromItem)fromItems.get(i);
            fromDataSets[i] = this.materializeFromItem(fromItem2, workSelectItems);
        }
        DataSet dataSet = MetaModelHelper.getCarthesianProduct(fromDataSets, whereItems);
        workSelectItems = CollectionUtils.concat(true, selectItems, groupBySelectItems, havingSelectItems, orderBySelectItems);
        dataSet = groupByItems.size() > 0 ? MetaModelHelper.getGrouped(workSelectItems, dataSet, groupByItems) : MetaModelHelper.getAggregated(workSelectItems, dataSet);
        dataSet = MetaModelHelper.getFiltered(dataSet, havingItems);
        if (query.getSelectClause().isDistinct()) {
            dataSet = MetaModelHelper.getSelection(selectItems, dataSet);
            dataSet = MetaModelHelper.getDistinct(dataSet);
            dataSet = MetaModelHelper.getOrdered(dataSet, orderByItems);
        } else {
            dataSet = MetaModelHelper.getOrdered(dataSet, orderByItems);
            dataSet = MetaModelHelper.getSelection(selectItems, dataSet);
        }
        dataSet = MetaModelHelper.getPaged(dataSet, firstRow, maxRows);
        return dataSet;
    }

    private boolean isSimpleSelect(SelectClause clause) {
        if (clause.isDistinct()) {
            return false;
        }
        for (SelectItem item : clause.getItems()) {
            if (item.getAggregateFunction() == null && item.getExpression() == null) continue;
            return false;
        }
        return true;
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        return null;
    }

    protected Row executePrimaryKeyLookupQuery(Table table, List<SelectItem> selectItems, Column primaryKeyColumn, Object keyValue) {
        return null;
    }

    protected DataSet materializeFromItem(FromItem fromItem, List<SelectItem> selectItems) {
        DataSet dataSet;
        JoinType joinType = fromItem.getJoin();
        if (fromItem.getTable() != null) {
            Table table = MetaModelHelper.resolveTable(fromItem);
            ArrayList<SelectItem> selectItemsToMaterialize = new ArrayList<SelectItem>();
            for (SelectItem selectItem : selectItems) {
                FromItem selectedFromItem = selectItem.getFromItem();
                if (selectedFromItem != null) {
                    if (!selectedFromItem.equals(fromItem)) continue;
                    selectItemsToMaterialize.add(selectItem.replaceFunction(null));
                    continue;
                }
                Column selectedColumn = selectItem.getColumn();
                if (selectedColumn == null || selectedColumn.getTable() == null || !selectedColumn.getTable().equals(table)) continue;
                selectItemsToMaterialize.add(selectItem.replaceFunction(null));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("calling materializeTable(" + table.getName() + "," + selectItemsToMaterialize + ",1,-1");
            }
            dataSet = this.materializeTable(table, selectItemsToMaterialize, Collections.emptyList(), 1, -1);
        } else if (joinType != null) {
            if (fromItem.getLeftSide() == null || fromItem.getRightSide() == null) {
                throw new IllegalArgumentException("Joined FromItem requires both left and right side: " + fromItem);
            }
            DataSet[] fromItemDataSets = new DataSet[2];
            List<SelectItem> leftOn = Arrays.asList(fromItem.getLeftOn());
            fromItemDataSets[0] = this.materializeFromItem(fromItem.getLeftSide(), CollectionUtils.concat(true, selectItems, leftOn));
            List<SelectItem> rightOn = Arrays.asList(fromItem.getRightOn());
            fromItemDataSets[1] = this.materializeFromItem(fromItem.getRightSide(), CollectionUtils.concat(true, selectItems, rightOn));
            FilterItem[] onConditions = new FilterItem[leftOn.size()];
            for (int i = 0; i < onConditions.length; ++i) {
                FilterItem whereItem;
                onConditions[i] = whereItem = new FilterItem(leftOn.get(i), OperatorType.EQUALS_TO, rightOn.get(i));
            }
            switch (joinType) {
                case INNER: {
                    dataSet = MetaModelHelper.getCarthesianProduct(fromItemDataSets, onConditions);
                    break;
                }
                case LEFT: {
                    dataSet = MetaModelHelper.getLeftJoin(fromItemDataSets[0], fromItemDataSets[1], onConditions);
                    break;
                }
                case RIGHT: {
                    dataSet = MetaModelHelper.getRightJoin(fromItemDataSets[0], fromItemDataSets[1], onConditions);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("FromItem type not supported: " + fromItem);
                }
            }
        } else if (fromItem.getSubQuery() != null) {
            dataSet = this.executeQuery(fromItem.getSubQuery());
        } else {
            throw new IllegalArgumentException("FromItem type not supported: " + fromItem);
        }
        if (dataSet == null) {
            throw new IllegalStateException("FromItem was not successfully materialized: " + fromItem);
        }
        return dataSet;
    }

    protected DataSet materializeTable(Table table, List<SelectItem> selectItems, List<FilterItem> whereItems, int firstRow, int maxRows) {
        DataSet dataSet;
        Schema schema;
        String schemaName;
        if (table == null) {
            throw new IllegalArgumentException("Table cannot be null");
        }
        if (selectItems == null || selectItems.isEmpty()) {
            List<Column> columns = table.getColumns();
            if (columns.size() == 0) {
                logger.warn("Queried table has no columns: {}", (Object)table);
            } else {
                selectItems.add(new SelectItem(columns.get(0)));
            }
        }
        if (INFORMATION_SCHEMA_NAME.equals(schemaName = (schema = table.getSchema()) == null ? null : schema.getName())) {
            DataSet informationDataSet = this.materializeInformationSchemaTable(table, this.buildWorkingSelectItems(selectItems, whereItems));
            informationDataSet = MetaModelHelper.getFiltered(informationDataSet, whereItems);
            informationDataSet = MetaModelHelper.getSelection(selectItems, informationDataSet);
            dataSet = informationDataSet = MetaModelHelper.getPaged(informationDataSet, firstRow, maxRows);
        } else {
            DataSet tableDataSet = this.materializeMainSchemaTable(table, selectItems, whereItems, firstRow, maxRows);
            dataSet = new ConvertedDataSetInterceptor(this.converters).intercept(tableDataSet);
        }
        return dataSet;
    }

    private List<SelectItem> buildWorkingSelectItems(List<SelectItem> selectItems, List<FilterItem> whereItems) {
        if (whereItems == null || whereItems.isEmpty()) {
            return selectItems;
        }
        List<SelectItem> evaluatedSelectItems = MetaModelHelper.getEvaluatedSelectItems(whereItems);
        LinkedHashSet<SelectItem> workingSelectItems = new LinkedHashSet<SelectItem>();
        workingSelectItems.addAll(selectItems);
        workingSelectItems.addAll(evaluatedSelectItems);
        return new ArrayList<SelectItem>(workingSelectItems);
    }

    protected boolean isScalarFunctionMaterialized(ScalarFunction function) {
        return false;
    }

    protected boolean isMainSchemaTable(Table table) {
        Schema schema = table.getSchema();
        return !INFORMATION_SCHEMA_NAME.equals(schema.getName());
    }

    @Override
    protected final List<String> getSchemaNamesInternal() throws MetaModelException {
        ArrayList<String> schemaNames = new ArrayList<String>();
        schemaNames.add(INFORMATION_SCHEMA_NAME);
        schemaNames.add(this.getMainSchemaName());
        return schemaNames;
    }

    @Override
    protected String getDefaultSchemaName() throws MetaModelException {
        return this.getMainSchemaName();
    }

    @Override
    protected final Schema getSchemaByNameInternal(String name) throws MetaModelException {
        String mainSchemaName = this.getMainSchemaName();
        if (name == null && mainSchemaName != null) {
            return null;
        }
        if (name == null || name.equalsIgnoreCase(mainSchemaName)) {
            boolean createAliasTable;
            Schema mainSchema = this.getMainSchema();
            boolean bl = createAliasTable = this.singleTableDatastore && Boolean.parseBoolean(System.getProperty(SYSTEM_PROPERTY_CREATE_DEFAULT_TABLE_ALIAS, "true"));
            if (createAliasTable) {
                return DefaultTableAliasedSchema.wrapIfAppropriate(mainSchema);
            }
            return mainSchema;
        }
        if (name.equals(INFORMATION_SCHEMA_NAME)) {
            return this.getInformationSchema();
        }
        logger.warn("Could not find matching schema of name '{}'. Main schema name is: '{}'. Returning null.", (Object)name, (Object)mainSchemaName);
        return null;
    }

    private Schema getInformationSchema() {
        MutableSchema informationSchema = new MutableSchema(INFORMATION_SCHEMA_NAME);
        MutableTable tablesTable = new MutableTable("tables", TableType.TABLE, informationSchema);
        MutableTable columnsTable = new MutableTable("columns", TableType.TABLE, informationSchema);
        MutableTable relationshipsTable = new MutableTable("relationships", TableType.TABLE, informationSchema);
        informationSchema.addTable(tablesTable).addTable(columnsTable).addTable(relationshipsTable);
        tablesTable.addColumn(new MutableColumn("name", ColumnType.VARCHAR, tablesTable, 0, false));
        tablesTable.addColumn(new MutableColumn("type", ColumnType.VARCHAR, tablesTable, 1, true));
        tablesTable.addColumn(new MutableColumn("num_columns", ColumnType.INTEGER, tablesTable, 2, true));
        tablesTable.addColumn(new MutableColumn("remarks", ColumnType.VARCHAR, tablesTable, 3, true));
        columnsTable.addColumn(new MutableColumn("name", ColumnType.VARCHAR, columnsTable, 0, false));
        columnsTable.addColumn(new MutableColumn("type", ColumnType.VARCHAR, columnsTable, 1, true));
        columnsTable.addColumn(new MutableColumn("native_type", ColumnType.VARCHAR, columnsTable, 2, true));
        columnsTable.addColumn(new MutableColumn("size", ColumnType.INTEGER, columnsTable, 3, true));
        columnsTable.addColumn(new MutableColumn("nullable", ColumnType.BOOLEAN, columnsTable, 4, true));
        columnsTable.addColumn(new MutableColumn("indexed", ColumnType.BOOLEAN, columnsTable, 5, true));
        columnsTable.addColumn(new MutableColumn("table", ColumnType.VARCHAR, columnsTable, 6, false));
        columnsTable.addColumn(new MutableColumn("remarks", ColumnType.VARCHAR, columnsTable, 7, true));
        relationshipsTable.addColumn(new MutableColumn("primary_table", ColumnType.VARCHAR, relationshipsTable, 0, false));
        relationshipsTable.addColumn(new MutableColumn("primary_column", ColumnType.VARCHAR, relationshipsTable, 1, false));
        relationshipsTable.addColumn(new MutableColumn("foreign_table", ColumnType.VARCHAR, relationshipsTable, 2, false));
        relationshipsTable.addColumn(new MutableColumn("foreign_column", ColumnType.VARCHAR, relationshipsTable, 3, false));
        MutableRelationship.createRelationship(tablesTable.getColumnByName("name"), columnsTable.getColumnByName("table"));
        MutableRelationship.createRelationship(tablesTable.getColumnByName("name"), relationshipsTable.getColumnByName("primary_table"));
        MutableRelationship.createRelationship(tablesTable.getColumnByName("name"), relationshipsTable.getColumnByName("foreign_table"));
        MutableRelationship.createRelationship(columnsTable.getColumnByName("name"), relationshipsTable.getColumnByName("primary_column"));
        MutableRelationship.createRelationship(columnsTable.getColumnByName("name"), relationshipsTable.getColumnByName("foreign_column"));
        return informationSchema;
    }

    private DataSet materializeInformationSchemaTable(Table table, List<SelectItem> selectItems) {
        String tableName = table.getName();
        List<SelectItem> columnSelectItems = table.getColumns().stream().map(SelectItem::new).collect(Collectors.toList());
        SimpleDataSetHeader header = new SimpleDataSetHeader(columnSelectItems);
        List<Table> tables = this.getDefaultSchema().getTables();
        ArrayList<Row> data = new ArrayList<Row>();
        if ("tables".equals(tableName)) {
            for (Table t : tables) {
                String typeString = null;
                if (t.getType() != null) {
                    typeString = t.getType().toString();
                }
                data.add(new DefaultRow(header, new Object[]{t.getName(), typeString, t.getColumnCount(), t.getRemarks()}));
            }
        } else if ("columns".equals(tableName)) {
            for (Table t : tables) {
                for (Column c : t.getColumns()) {
                    String typeString = null;
                    if (t.getType() != null) {
                        typeString = c.getType().toString();
                    }
                    data.add(new DefaultRow(header, new Object[]{c.getName(), typeString, c.getNativeType(), c.getColumnSize(), c.isNullable(), c.isIndexed(), t.getName(), c.getRemarks()}));
                }
            }
        } else if ("relationships".equals(tableName)) {
            for (Relationship r : this.getDefaultSchema().getRelationships()) {
                List<Column> primaryColumns = r.getPrimaryColumns();
                List<Column> foreignColumns = r.getForeignColumns();
                Table pTable = r.getPrimaryTable();
                Table fTable = r.getForeignTable();
                for (int i = 0; i < primaryColumns.size(); ++i) {
                    Column pColumn = primaryColumns.get(i);
                    Column fColumn = foreignColumns.get(i);
                    data.add(new DefaultRow(header, new Object[]{pTable.getName(), pColumn.getName(), fTable.getName(), fColumn.getName()}));
                }
            }
        } else {
            throw new IllegalArgumentException("Cannot materialize non information_schema table: " + table);
        }
        DataSet dataSet = data.isEmpty() ? new EmptyDataSet(selectItems) : new InMemoryDataSet((DataSetHeader)header, data);
        DataSet selectionDataSet = MetaModelHelper.getSelection(selectItems, dataSet);
        dataSet = selectionDataSet;
        return dataSet;
    }

    @Override
    public void addConverter(Column column, TypeConverter<?, ?> converter) {
        this.converters.put(column, converter);
    }

    protected abstract Schema getMainSchema() throws MetaModelException;

    protected abstract String getMainSchemaName() throws MetaModelException;

    protected DataSet materializeMainSchemaTable(Table table, List<SelectItem> selectItems, List<FilterItem> whereItems, int firstRow, int maxRows) {
        DataSet dataSet;
        List<SelectItem> workingSelectItems = this.buildWorkingSelectItems(selectItems, whereItems);
        if (whereItems.isEmpty()) {
            dataSet = this.materializeMainSchemaTableSelect(table, workingSelectItems, firstRow, maxRows);
            dataSet = MetaModelHelper.getSelection(selectItems, dataSet);
        } else {
            dataSet = this.materializeMainSchemaTableSelect(table, workingSelectItems, 1, -1);
            dataSet = MetaModelHelper.getFiltered(dataSet, whereItems);
            dataSet = MetaModelHelper.getPaged(dataSet, firstRow, maxRows);
            dataSet = MetaModelHelper.getSelection(selectItems, dataSet);
        }
        return dataSet;
    }

    protected DataSet materializeMainSchemaTableSelect(Table table, List<SelectItem> selectItems, int firstRow, int maxRows) {
        List<Column> columns = selectItems.stream().map(si -> si.getColumn()).collect(Collectors.toList());
        DataSet dataSet = this.materializeMainSchemaTable(table, columns, firstRow, maxRows);
        dataSet = MetaModelHelper.getSelection(selectItems, dataSet);
        return dataSet;
    }

    protected DataSet materializeMainSchemaTable(Table table, List<Column> columns, int firstRow, int maxRows) {
        int rowsToMaterialize = firstRow == 1 ? maxRows : maxRows + (firstRow - 1);
        DataSet dataSet = this.materializeMainSchemaTable(table, columns, rowsToMaterialize);
        if (firstRow > 1) {
            dataSet = new FirstRowDataSet(dataSet, firstRow);
        }
        return dataSet;
    }

    protected abstract DataSet materializeMainSchemaTable(Table var1, List<Column> var2, int var3);
}

