/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.data.CachingDataSetHeader;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.EmptyDataSet;
import org.apache.metamodel.data.FilteredDataSet;
import org.apache.metamodel.data.FirstRowDataSet;
import org.apache.metamodel.data.InMemoryDataSet;
import org.apache.metamodel.data.MaxRowsDataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.ScalarFunctionDataSet;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.data.SubSelectionDataSet;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.query.GroupByItem;
import org.apache.metamodel.query.OrderByItem;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.query.parser.QueryParser;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.SuperColumnType;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.WrappingSchema;
import org.apache.metamodel.schema.WrappingTable;
import org.apache.metamodel.util.AggregateBuilder;
import org.apache.metamodel.util.CollectionUtils;
import org.apache.metamodel.util.ObjectComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetaModelHelper {
    private static final Logger logger = LoggerFactory.getLogger(MetaModelHelper.class);

    private MetaModelHelper() {
    }

    public static Table[] getTables(Collection<Table> tableList, Iterable<Column> columnList) {
        HashSet<Table> set = new HashSet<Table>();
        set.addAll(tableList);
        for (Column column : columnList) {
            set.add(column.getTable());
        }
        return set.toArray(new Table[set.size()]);
    }

    public static boolean isInformationSchema(Schema schema) {
        String name = schema.getName();
        return MetaModelHelper.isInformationSchema(name);
    }

    public static boolean isInformationSchema(String name) {
        if (name == null) {
            return false;
        }
        return "information_schema".equals(name.toLowerCase());
    }

    public static Table[] getTables(Iterable<Column> columns) {
        ArrayList<Table> result = new ArrayList<Table>();
        for (Column column : columns) {
            Table table = column.getTable();
            if (result.contains(table)) continue;
            result.add(table);
        }
        return result.toArray(new Table[result.size()]);
    }

    public static Column[] getTableColumns(Table table, Iterable<Column> columns) {
        if (table == null) {
            return new Column[0];
        }
        ArrayList<Column> result = new ArrayList<Column>();
        for (Column column : columns) {
            boolean sameTable = table.equals(column.getTable());
            if (!sameTable) continue;
            result.add(column);
        }
        return result.toArray(new Column[result.size()]);
    }

    public static Column[] getTableColumns(Table table, Column[] columns) {
        return MetaModelHelper.getTableColumns(table, Arrays.asList(columns));
    }

    public static DataSet getCarthesianProduct(DataSet ... fromDataSets) {
        return MetaModelHelper.getCarthesianProduct(fromDataSets, new FilterItem[0]);
    }

    public static DataSet getCarthesianProduct(DataSet[] fromDataSets, FilterItem ... filterItems) {
        return MetaModelHelper.getCarthesianProduct(fromDataSets, Arrays.asList(filterItems));
    }

    public static DataSet getCarthesianProduct(DataSet[] fromDataSets, Iterable<FilterItem> whereItems) {
        assert (fromDataSets.length > 0);
        if (fromDataSets.length == 1) {
            return MetaModelHelper.getFiltered(fromDataSets[0], whereItems);
        }
        Iterator<DataSet> dsIter = Arrays.asList(fromDataSets).iterator();
        DataSet joined = dsIter.next();
        while (dsIter.hasNext()) {
            joined = MetaModelHelper.nestedLoopJoin(dsIter.next(), joined, whereItems);
        }
        return joined;
    }

    public static InMemoryDataSet nestedLoopJoin(DataSet innerLoopDs, DataSet outerLoopDs, Iterable<FilterItem> filtersIterable) {
        ArrayList<FilterItem> filters = new ArrayList<FilterItem>();
        for (FilterItem fi2 : filtersIterable) {
            filters.add(fi2);
        }
        List<Row> innerRows = innerLoopDs.toRows();
        ArrayList<SelectItem> allItems = new ArrayList<SelectItem>(outerLoopDs.getSelectItems());
        allItems.addAll(innerLoopDs.getSelectItems());
        Set<FilterItem> applicableFilters = MetaModelHelper.applicableFilters(filters, allItems);
        CachingDataSetHeader jointHeader = new CachingDataSetHeader(allItems);
        ArrayList<Row> resultRows = new ArrayList<Row>();
        for (Row outerRow : outerLoopDs) {
            for (Row innerRow : innerRows) {
                Object[] joinedRowObjects = new Object[outerRow.getValues().length + innerRow.getValues().length];
                System.arraycopy(outerRow.getValues(), 0, joinedRowObjects, 0, outerRow.getValues().length);
                System.arraycopy(innerRow.getValues(), 0, joinedRowObjects, outerRow.getValues().length, innerRow.getValues().length);
                DefaultRow joinedRow = new DefaultRow(jointHeader, joinedRowObjects);
                if (!applicableFilters.isEmpty() && !applicableFilters.stream().allMatch(fi -> fi.accept(joinedRow))) continue;
                resultRows.add(joinedRow);
            }
        }
        return new InMemoryDataSet((DataSetHeader)jointHeader, resultRows);
    }

    private static Set<FilterItem> applicableFilters(Collection<FilterItem> filters, Collection<SelectItem> selectItemList) {
        HashSet<SelectItem> items = new HashSet<SelectItem>(selectItemList);
        return filters.stream().filter(fi -> items.containsAll(MetaModelHelper.getSelectItems(fi))).collect(Collectors.toSet());
    }

    private static Set<SelectItem> getSelectItems(FilterItem filterItem) {
        HashSet<SelectItem> itemsInFilter = new HashSet<SelectItem>();
        if (filterItem.getChildItemCount() == 0) {
            itemsInFilter.add(filterItem.getSelectItem());
            Object operand = filterItem.getOperand();
            if (operand instanceof SelectItem) {
                itemsInFilter.add((SelectItem)operand);
            }
        } else {
            for (FilterItem childFilterItem : filterItem.getChildItems()) {
                itemsInFilter.addAll(MetaModelHelper.getSelectItems(childFilterItem));
            }
        }
        return itemsInFilter;
    }

    public static DataSet getFiltered(DataSet dataSet, Iterable<FilterItem> filterItems) {
        FilterItem[] filterItemsArray = (FilterItem[])StreamSupport.stream(filterItems.spliterator(), false).toArray(FilterItem[]::new);
        return MetaModelHelper.getFiltered(dataSet, filterItemsArray);
    }

    public static DataSet getFiltered(DataSet dataSet, FilterItem ... filterItems) {
        if (filterItems == null || filterItems.length == 0) {
            return dataSet;
        }
        return MetaModelHelper.getFiltered(dataSet, Arrays.asList(filterItems));
    }

    public static DataSet getFiltered(DataSet dataSet, Collection<FilterItem> filterItems) {
        boolean calculateScalarFunctions;
        if (filterItems == null || filterItems.isEmpty()) {
            return dataSet;
        }
        List<SelectItem> selectItemsOnOutput = dataSet.getSelectItems();
        Iterable<SelectItem> selectItems = filterItems.stream().map(f -> f.getSelectItem()).filter(s -> s != null)::iterator;
        List<SelectItem> scalarFunctionSelectItems = MetaModelHelper.getUnmaterializedScalarFunctionSelectItems(selectItems, dataSet);
        boolean bl = calculateScalarFunctions = !scalarFunctionSelectItems.isEmpty();
        if (calculateScalarFunctions) {
            dataSet = new ScalarFunctionDataSet(scalarFunctionSelectItems, dataSet);
        }
        FilteredDataSet filteredDataSet = new FilteredDataSet(dataSet, filterItems);
        if (calculateScalarFunctions) {
            return MetaModelHelper.getSelection(selectItemsOnOutput, (DataSet)filteredDataSet);
        }
        return filteredDataSet;
    }

    public static DataSet getSelection(List<SelectItem> selectItems, DataSet dataSet) {
        List<SelectItem> dataSetSelectItems = dataSet.getSelectItems();
        if (selectItems.equals(dataSetSelectItems)) {
            return dataSet;
        }
        ArrayList<SelectItem> scalarFunctionSelectItemsToEvaluate = new ArrayList<SelectItem>();
        for (SelectItem selectItem : selectItems) {
            if (selectItem.getScalarFunction() == null || dataSetSelectItems.contains(selectItem) || !dataSetSelectItems.contains(selectItem.replaceFunction(null))) continue;
            scalarFunctionSelectItemsToEvaluate.add(selectItem);
        }
        if (scalarFunctionSelectItemsToEvaluate.isEmpty()) {
            return new SubSelectionDataSet(selectItems, dataSet);
        }
        ScalarFunctionDataSet scalaFunctionDataSet = new ScalarFunctionDataSet(scalarFunctionSelectItemsToEvaluate, dataSet);
        return new SubSelectionDataSet(selectItems, (DataSet)scalaFunctionDataSet);
    }

    public static DataSet getSelection(SelectItem[] selectItems, DataSet dataSet) {
        return MetaModelHelper.getSelection(Arrays.asList(selectItems), dataSet);
    }

    public static DataSet getGrouped(List<SelectItem> selectItems, DataSet dataSet, Collection<GroupByItem> groupByItems) {
        DataSet result = dataSet;
        if (groupByItems != null && groupByItems.size() > 0) {
            HashMap uniqueRows = new HashMap();
            List<SelectItem> groupBySelects = groupByItems.stream().map(gbi -> gbi.getSelectItem()).collect(Collectors.toList());
            CachingDataSetHeader groupByHeader = new CachingDataSetHeader(groupBySelects);
            List<SelectItem> functionItems = MetaModelHelper.getAggregateFunctionSelectItems(selectItems);
            while (dataSet.next()) {
                Map functionInput;
                Row row = dataSet.getRow();
                Row uniqueRow = row.getSubSelection(groupByHeader);
                if (!uniqueRows.containsKey(uniqueRow)) {
                    functionInput = new HashMap();
                    for (SelectItem item : functionItems) {
                        functionInput.put(item, new ArrayList());
                    }
                    uniqueRows.put(uniqueRow, functionInput);
                } else {
                    functionInput = (Map)uniqueRows.get(uniqueRow);
                }
                for (SelectItem item : functionItems) {
                    List objects = (List)functionInput.get(item);
                    Column column = item.getColumn();
                    if (column != null) {
                        Object value = row.getValue(new SelectItem(column));
                        objects.add(value);
                        continue;
                    }
                    if (SelectItem.isCountAllItem(item)) {
                        objects.add("");
                        continue;
                    }
                    throw new IllegalArgumentException("Expression function not supported: " + item);
                }
            }
            dataSet.close();
            ArrayList<Row> resultData = new ArrayList<Row>();
            CachingDataSetHeader resultHeader = new CachingDataSetHeader(selectItems);
            for (Map.Entry entry : uniqueRows.entrySet()) {
                Row row = (Row)entry.getKey();
                Map functionInput = (Map)entry.getValue();
                Object[] resultRow = new Object[selectItems.size()];
                int i = 0;
                for (SelectItem item : selectItems) {
                    int uniqueRowIndex = row.indexOf(item);
                    if (uniqueRowIndex != -1) {
                        resultRow[i] = row.getValue(uniqueRowIndex);
                    } else {
                        List objects = (List)functionInput.get(item);
                        if (objects != null) {
                            Object functionResult;
                            resultRow[i] = functionResult = item.getAggregateFunction().evaluate(objects.toArray());
                        } else if (item.getAggregateFunction() != null) {
                            logger.error("No function input found for SelectItem: {}", (Object)item);
                        }
                    }
                    ++i;
                }
                resultData.add(new DefaultRow(resultHeader, resultRow, null));
            }
            result = resultData.isEmpty() ? new EmptyDataSet(selectItems) : new InMemoryDataSet((DataSetHeader)resultHeader, resultData);
        }
        result = MetaModelHelper.getSelection(selectItems, result);
        return result;
    }

    public static DataSet getAggregated(List<SelectItem> workSelectItems, DataSet dataSet) {
        AggregateBuilder aggregateBuilder;
        SimpleDataSetHeader header;
        boolean onlyAggregates;
        List<SelectItem> functionItems = MetaModelHelper.getAggregateFunctionSelectItems(workSelectItems);
        if (functionItems.isEmpty()) {
            return dataSet;
        }
        HashMap aggregateBuilders = new HashMap();
        for (SelectItem item : functionItems) {
            aggregateBuilders.put(item, item.getAggregateFunction().createAggregateBuilder());
        }
        if (functionItems.size() != workSelectItems.size()) {
            onlyAggregates = false;
            header = new CachingDataSetHeader(workSelectItems);
        } else {
            onlyAggregates = true;
            header = new SimpleDataSetHeader(workSelectItems);
        }
        ArrayList<Row> resultRows = new ArrayList<Row>();
        while (dataSet.next()) {
            Row inputRow = dataSet.getRow();
            for (SelectItem item : functionItems) {
                aggregateBuilder = (AggregateBuilder)aggregateBuilders.get(item);
                Column column = item.getColumn();
                if (column != null) {
                    Object value = inputRow.getValue(new SelectItem(column));
                    aggregateBuilder.add(value);
                    continue;
                }
                if (SelectItem.isCountAllItem(item)) {
                    aggregateBuilder.add("");
                    continue;
                }
                throw new IllegalArgumentException("Expression function not supported: " + item);
            }
            if (onlyAggregates) continue;
            Object[] values = new Object[header.size()];
            for (int i = 0; i < header.size(); ++i) {
                Object value = inputRow.getValue(header.getSelectItem(i));
                if (value == null) continue;
                values[i] = value;
            }
            resultRows.add(new DefaultRow(header, values));
        }
        dataSet.close();
        HashMap functionResult = new HashMap();
        for (SelectItem item : functionItems) {
            aggregateBuilder = (AggregateBuilder)aggregateBuilders.get(item);
            Object result = aggregateBuilder.getAggregate();
            functionResult.put(item, result);
        }
        boolean noResultRows = resultRows.isEmpty();
        if (onlyAggregates || noResultRows) {
            Object[] values = new Object[header.size()];
            for (int i = 0; i < header.size(); ++i) {
                values[i] = functionResult.get(header.getSelectItem(i));
            }
            DefaultRow row = new DefaultRow(header, values);
            resultRows.add(row);
        } else {
            for (int i = 0; i < resultRows.size(); ++i) {
                Row row = (Row)resultRows.get(i);
                Object[] values = row.getValues();
                for (Map.Entry entry : functionResult.entrySet()) {
                    SelectItem item = (SelectItem)entry.getKey();
                    int itemIndex = row.indexOf(item);
                    if (itemIndex == -1) continue;
                    Object value = entry.getValue();
                    values[itemIndex] = value;
                }
                resultRows.set(i, new DefaultRow(header, values));
            }
        }
        return new InMemoryDataSet((DataSetHeader)header, resultRows);
    }

    public static List<SelectItem> getAggregateFunctionSelectItems(Iterable<SelectItem> selectItems) {
        return CollectionUtils.filter(selectItems, arg -> arg.getAggregateFunction() != null);
    }

    public static List<SelectItem> getScalarFunctionSelectItems(Iterable<SelectItem> selectItems) {
        return MetaModelHelper.getUnmaterializedScalarFunctionSelectItems(selectItems, null);
    }

    public static List<SelectItem> getUnmaterializedScalarFunctionSelectItems(Iterable<SelectItem> selectItems, DataSet dataSetWithMaterializedSelectItems) {
        return CollectionUtils.filter(selectItems, arg -> arg.getScalarFunction() != null && (dataSetWithMaterializedSelectItems == null || dataSetWithMaterializedSelectItems.indexOf((SelectItem)arg) == -1));
    }

    public static DataSet getOrdered(DataSet dataSet, List<OrderByItem> orderByItems) {
        return MetaModelHelper.getOrdered(dataSet, orderByItems.toArray(new OrderByItem[orderByItems.size()]));
    }

    public static DataSet getOrdered(DataSet dataSet, final OrderByItem ... orderByItems) {
        if (orderByItems != null && orderByItems.length != 0) {
            final int[] sortIndexes = new int[orderByItems.length];
            for (int i = 0; i < orderByItems.length; ++i) {
                int indexOf;
                OrderByItem item = orderByItems[i];
                sortIndexes[i] = indexOf = dataSet.indexOf(item.getSelectItem());
            }
            List<Row> data = MetaModelHelper.readDataSetFull(dataSet);
            if (data.isEmpty()) {
                return new EmptyDataSet(dataSet.getSelectItems());
            }
            final Comparator<Object> valueComparator = ObjectComparator.getComparator();
            Comparator<Row> comparator = new Comparator<Row>(){

                @Override
                public int compare(Row o1, Row o2) {
                    for (int i = 0; i < sortIndexes.length; ++i) {
                        Object sortObj2;
                        int sortIndex = sortIndexes[i];
                        Object sortObj1 = o1.getValue(sortIndex);
                        int compare = valueComparator.compare(sortObj1, sortObj2 = o2.getValue(sortIndex));
                        if (compare == 0) continue;
                        OrderByItem orderByItem = orderByItems[i];
                        boolean ascending = orderByItem.isAscending();
                        if (ascending) {
                            return compare;
                        }
                        return compare * -1;
                    }
                    return 0;
                }
            };
            Collections.sort(data, comparator);
            dataSet = new InMemoryDataSet(data);
        }
        return dataSet;
    }

    public static List<Row> readDataSetFull(DataSet dataSet) {
        List<Row> result;
        if (dataSet instanceof InMemoryDataSet) {
            result = ((InMemoryDataSet)dataSet).getRows();
        } else {
            result = new ArrayList<Row>();
            while (dataSet.next()) {
                result.add(dataSet.getRow());
            }
        }
        dataSet.close();
        return result;
    }

    public static FromItem[] getTableFromItems(Query q) {
        ArrayList<FromItem> result = new ArrayList<FromItem>();
        List items = q.getFromClause().getItems();
        for (FromItem item : items) {
            result.addAll(MetaModelHelper.getTableFromItems(item));
        }
        return result.toArray(new FromItem[result.size()]);
    }

    public static List<FromItem> getTableFromItems(FromItem item) {
        ArrayList<FromItem> result = new ArrayList<FromItem>();
        if (item.getTable() != null) {
            result.add(item);
        } else if (item.getSubQuery() != null) {
            FromItem[] sqItems = MetaModelHelper.getTableFromItems(item.getSubQuery());
            for (int i = 0; i < sqItems.length; ++i) {
                result.add(sqItems[i]);
            }
        } else if (item.getJoin() != null) {
            FromItem leftSide = item.getLeftSide();
            result.addAll(MetaModelHelper.getTableFromItems(leftSide));
            FromItem rightSide = item.getRightSide();
            result.addAll(MetaModelHelper.getTableFromItems(rightSide));
        } else {
            throw new IllegalStateException("FromItem was neither of Table type, SubQuery type or Join type: " + item);
        }
        return result;
    }

    public static Row executeSingleRowQuery(DataContext dataContext, Query query) throws MetaModelException {
        DataSet dataSet = dataContext.executeQuery(query);
        boolean next = dataSet.next();
        if (!next) {
            throw new MetaModelException("No rows returned from query: " + query);
        }
        Row row = dataSet.getRow();
        next = dataSet.next();
        if (next) {
            throw new MetaModelException("More than one row returned from query: " + query);
        }
        dataSet.close();
        return row;
    }

    public static DataSet getLeftJoin(DataSet ds1, DataSet ds2, FilterItem[] onConditions) {
        if (ds1 == null) {
            throw new IllegalArgumentException("Left DataSet cannot be null");
        }
        if (ds2 == null) {
            throw new IllegalArgumentException("Right DataSet cannot be null");
        }
        List<SelectItem> si1 = ds1.getSelectItems();
        List<SelectItem> si2 = ds2.getSelectItems();
        List<SelectItem> selectItems = Stream.concat(si1.stream(), si2.stream()).collect(Collectors.toList());
        ArrayList<Row> resultRows = new ArrayList<Row>();
        List<Row> ds2data = MetaModelHelper.readDataSetFull(ds2);
        if (ds2data.isEmpty()) {
            return MetaModelHelper.getSelection(selectItems, ds1);
        }
        CachingDataSetHeader header = new CachingDataSetHeader(selectItems);
        while (ds1.next()) {
            Row ds1row = ds1.getRow();
            ArrayList<Row> ds1rows = new ArrayList<Row>();
            ds1rows.add(ds1row);
            DataSet carthesianProduct = MetaModelHelper.getCarthesianProduct(new DataSet[]{new InMemoryDataSet((DataSetHeader)new CachingDataSetHeader(si1), ds1rows), new InMemoryDataSet((DataSetHeader)new CachingDataSetHeader(si2), ds2data)}, onConditions);
            List<Row> carthesianRows = MetaModelHelper.readDataSetFull(carthesianProduct);
            if (carthesianRows.size() > 0) {
                resultRows.addAll(carthesianRows);
                continue;
            }
            Object[] values = ds1row.getValues();
            Object[] row = new Object[selectItems.size()];
            System.arraycopy(values, 0, row, 0, values.length);
            resultRows.add(new DefaultRow(header, row));
        }
        ds1.close();
        if (resultRows.isEmpty()) {
            return new EmptyDataSet(selectItems);
        }
        return new InMemoryDataSet((DataSetHeader)header, resultRows);
    }

    public static DataSet getRightJoin(DataSet ds1, DataSet ds2, FilterItem[] onConditions) {
        List<SelectItem> ds1selects = ds1.getSelectItems();
        List<SelectItem> ds2selects = ds2.getSelectItems();
        ArrayList<SelectItem> leftOrderedSelects = new ArrayList<SelectItem>();
        leftOrderedSelects.addAll(ds1selects);
        leftOrderedSelects.addAll(ds2selects);
        DataSet dataSet = MetaModelHelper.getLeftJoin(ds2, ds1, onConditions);
        dataSet = MetaModelHelper.getSelection(leftOrderedSelects, dataSet);
        return dataSet;
    }

    public static SelectItem[] createSelectItems(Column ... columns) {
        SelectItem[] items = new SelectItem[columns.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = new SelectItem(columns[i]);
        }
        return items;
    }

    public static DataSet getDistinct(DataSet dataSet) {
        List<SelectItem> selectItems = dataSet.getSelectItems();
        List<GroupByItem> groupByItems = selectItems.stream().map(GroupByItem::new).collect(Collectors.toList());
        return MetaModelHelper.getGrouped(selectItems, dataSet, groupByItems);
    }

    public static Table[] getTables(Column[] columns) {
        return MetaModelHelper.getTables(Arrays.asList(columns));
    }

    public static Column[] getColumnsByType(Column[] columns, ColumnType columnType) {
        return CollectionUtils.filter(columns, column -> column.getType() == columnType).toArray(new Column[0]);
    }

    public static Column[] getColumnsBySuperType(Column[] columns, SuperColumnType superColumnType) {
        return CollectionUtils.filter(columns, column -> column.getType().getSuperType() == superColumnType).toArray(new Column[0]);
    }

    public static Query parseQuery(DataContext dc, String queryString) {
        QueryParser parser = new QueryParser(dc, queryString);
        return parser.parse();
    }

    public static DataSet getPaged(DataSet dataSet, int firstRow, int maxRows) {
        if (firstRow > 1) {
            dataSet = new FirstRowDataSet(dataSet, firstRow);
        }
        if (maxRows != -1) {
            dataSet = new MaxRowsDataSet(dataSet, maxRows);
        }
        return dataSet;
    }

    public static List<SelectItem> getEvaluatedSelectItems(List<FilterItem> items) {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        for (FilterItem item : items) {
            MetaModelHelper.addEvaluatedSelectItems(result, item);
        }
        return result;
    }

    private static void addEvaluatedSelectItems(List<SelectItem> result, FilterItem item) {
        Object operand;
        SelectItem selectItem;
        FilterItem[] orItems = item.getChildItems();
        if (orItems != null) {
            for (FilterItem filterItem : orItems) {
                MetaModelHelper.addEvaluatedSelectItems(result, filterItem);
            }
        }
        if ((selectItem = item.getSelectItem()) != null && !result.contains(selectItem)) {
            result.add(selectItem);
        }
        if ((operand = item.getOperand()) != null && operand instanceof SelectItem && !result.contains(operand)) {
            result.add((SelectItem)operand);
        }
    }

    public static SelectItem getSelectItemByAlias(Query query, String alias) {
        List selectItems = query.getSelectClause().getItems();
        for (SelectItem selectItem : selectItems) {
            if (selectItem.getAlias() == null || !selectItem.getAlias().equals(alias)) continue;
            return selectItem;
        }
        return null;
    }

    public static boolean containsNonSelectScalaFunctions(Query query) {
        List fromItems = query.getFromClause().getItems();
        for (FromItem fromItem : fromItems) {
            Query subQuery = fromItem.getSubQuery();
            if (subQuery == null) continue;
            if (MetaModelHelper.containsNonSelectScalaFunctions(subQuery)) {
                return true;
            }
            if (MetaModelHelper.getScalarFunctionSelectItems(subQuery.getSelectClause().getItems()).isEmpty()) continue;
            return true;
        }
        if (!MetaModelHelper.getScalarFunctionSelectItems(query.getWhereClause().getEvaluatedSelectItems()).isEmpty()) {
            return true;
        }
        if (!MetaModelHelper.getScalarFunctionSelectItems(query.getGroupByClause().getEvaluatedSelectItems()).isEmpty()) {
            return true;
        }
        if (!MetaModelHelper.getScalarFunctionSelectItems(query.getHavingClause().getEvaluatedSelectItems()).isEmpty()) {
            return true;
        }
        return !MetaModelHelper.getScalarFunctionSelectItems(query.getOrderByClause().getEvaluatedSelectItems()).isEmpty();
    }

    public static Table resolveTable(FromItem fromItem) {
        Table table = fromItem.getTable();
        return MetaModelHelper.resolveUnderlyingTable(table);
    }

    public static Table resolveUnderlyingTable(Table table) {
        while (table instanceof WrappingTable) {
            table = ((WrappingTable)table).getWrappedTable();
        }
        return table;
    }

    public static Schema resolveUnderlyingSchema(Schema schema) {
        while (schema instanceof WrappingSchema) {
            schema = ((WrappingSchema)schema).getWrappedSchema();
        }
        return schema;
    }
}

