/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel;

import java.util.List;
import java.util.ListIterator;
import org.apache.metamodel.AbstractUpdateCallback;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.delete.RowDeletionBuilder;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.update.AbstractRowUpdationBuilder;

public class DeleteAndInsertBuilder
extends AbstractRowUpdationBuilder {
    private final AbstractUpdateCallback _updateCallback;

    public DeleteAndInsertBuilder(AbstractUpdateCallback updateCallback, Table table) {
        super(table);
        assert (updateCallback.isInsertSupported());
        assert (updateCallback.isDeleteSupported());
        this._updateCallback = updateCallback;
    }

    @Override
    public void execute() throws MetaModelException {
        List<Row> rows = this.getRowsToUpdate();
        ((RowDeletionBuilder)this._updateCallback.deleteFrom(this.getTable()).where(this.getWhereItems())).execute();
        rows = this.updateRows(rows);
        for (Row row : rows) {
            this._updateCallback.insertInto(this.getTable()).like(row).execute();
        }
    }

    private List<Row> updateRows(List<Row> rows) {
        ListIterator<Row> it = rows.listIterator();
        while (it.hasNext()) {
            Row original = it.next();
            Row updated = this.update(original);
            it.set(updated);
        }
        return rows;
    }

    private Row update(Row original) {
        List<SelectItem> items = original.getSelectItems();
        Object[] values = new Object[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            Column column = items.get(i).getColumn();
            Object value = this.isSet(column) ? this.getValues()[i] : original.getValue(i);
            values[i] = value;
        }
        return new DefaultRow(new SimpleDataSetHeader(items), values);
    }

    protected List<Row> getRowsToUpdate() {
        DataContext dc = this._updateCallback.getDataContext();
        Table table = this.getTable();
        List<FilterItem> whereItems = this.getWhereItems();
        try (DataSet dataSet = dc.query().from(table).select(table.getColumns()).where(whereItems).execute();){
            List<Row> list = dataSet.toRows();
            return list;
        }
    }
}

