/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import org.apache.metamodel.AbstractDataContext;
import org.apache.metamodel.CompositeQueryDelegate;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.MetaModelHelper;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.schema.CompositeSchema;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.WrappingSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeDataContext
extends AbstractDataContext {
    private static final Logger logger = LoggerFactory.getLogger(CompositeDataContext.class);
    private Map<String, CompositeSchema> _compositeSchemas = new HashMap<String, CompositeSchema>();
    private DataContext[] _delegates;

    public CompositeDataContext(DataContext ... delegates) {
        if (delegates == null) {
            throw new IllegalArgumentException("delegates cannot be null");
        }
        this._delegates = delegates;
    }

    public CompositeDataContext(Collection<DataContext> delegates) {
        if (delegates == null) {
            throw new IllegalArgumentException("delegates cannot be null");
        }
        this._delegates = delegates.toArray(new DataContext[delegates.size()]);
    }

    @Override
    public DataSet executeQuery(Query query) throws MetaModelException {
        HashSet<DataContext> dataContexts = new HashSet<DataContext>();
        List items = query.getFromClause().getItems();
        for (FromItem item : items) {
            List<FromItem> tableFromItems = MetaModelHelper.getTableFromItems(item);
            for (FromItem fromItem : tableFromItems) {
                Table table2 = fromItem.getTable();
                DataContext dc = this.getDataContext(table2);
                if (dc == null) {
                    throw new MetaModelException("Could not resolve child-datacontext for table: " + table2);
                }
                dataContexts.add(dc);
            }
        }
        if (dataContexts.isEmpty()) {
            throw new MetaModelException("No suiting delegate DataContext to execute query: " + query);
        }
        if (dataContexts.size() == 1) {
            Iterator it = dataContexts.iterator();
            assert (it.hasNext());
            DataContext dc = (DataContext)it.next();
            return dc.executeQuery(query);
        }
        Function<Table, DataContext> dataContextRetrievalFunction = table -> this.getDataContext((Table)table);
        return new CompositeQueryDelegate(dataContextRetrievalFunction).executeQuery(query);
    }

    private DataContext getDataContext(Table table) {
        Schema schema;
        DataContext result = null;
        if (table != null && (schema = table.getSchema()) != null) {
            Schema dcSchema;
            for (DataContext dc : this._delegates) {
                dcSchema = dc.getSchemaByName(schema.getName());
                if (dcSchema == null || dcSchema != schema) continue;
                logger.debug("DataContext for '{}' resolved (using identity) to: '{}'", (Object)table, (Object)dcSchema);
                result = dc;
                break;
            }
            if (result == null) {
                for (DataContext dc : this._delegates) {
                    dcSchema = dc.getSchemaByName(schema.getName());
                    if (dcSchema == null || !dcSchema.equals(schema) && (!(dcSchema instanceof WrappingSchema) || !((WrappingSchema)dcSchema).getWrappedSchema().equals(schema))) continue;
                    logger.debug("DataContext for '{}' resolved (using equals) to: '{}'", (Object)table, (Object)dcSchema);
                    result = dc;
                    break;
                }
            }
        }
        if (result == null) {
            logger.warn("Couldn't resolve DataContext for {}", (Object)table);
        }
        return result;
    }

    @Override
    public String getDefaultSchemaName() throws MetaModelException {
        for (DataContext dc : this._delegates) {
            Schema schema = dc.getDefaultSchema();
            if (schema == null) continue;
            return schema.getName();
        }
        return null;
    }

    @Override
    public Schema getSchemaByNameInternal(String name) throws MetaModelException {
        CompositeSchema compositeSchema = this._compositeSchemas.get(name);
        if (compositeSchema != null) {
            return compositeSchema;
        }
        ArrayList<Schema> matchingSchemas = new ArrayList<Schema>();
        for (DataContext dc : this._delegates) {
            Schema schema = dc.getSchemaByName(name);
            if (schema == null) continue;
            matchingSchemas.add(schema);
        }
        if (matchingSchemas.size() == 1) {
            return (Schema)matchingSchemas.iterator().next();
        }
        if (matchingSchemas.size() > 1) {
            if (logger.isInfoEnabled()) {
                logger.info("Name-clash detected for Schema '{}'. Creating CompositeSchema.");
            }
            compositeSchema = new CompositeSchema(name, matchingSchemas);
            this._compositeSchemas.put(name, compositeSchema);
            return compositeSchema;
        }
        return null;
    }

    @Override
    public List<String> getSchemaNamesInternal() throws MetaModelException {
        TreeSet<String> set = new TreeSet<String>();
        for (DataContext dc : this._delegates) {
            List<String> schemaNames = dc.getSchemaNames();
            for (String name : schemaNames) {
                if (MetaModelHelper.isInformationSchema(name)) continue;
                set.add(name);
            }
        }
        return new ArrayList<String>(set);
    }
}

