/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel;

import java.util.Arrays;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.DefaultUpdateSummary;
import org.apache.metamodel.DeleteAndInsertBuilder;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateSummary;
import org.apache.metamodel.create.TableCreationBuilder;
import org.apache.metamodel.delete.RowDeletionBuilder;
import org.apache.metamodel.drop.TableDropBuilder;
import org.apache.metamodel.insert.RowInsertionBuilder;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.update.RowUpdationBuilder;

public abstract class AbstractUpdateCallback
implements UpdateCallback {
    private final DataContext _dataContext;

    public AbstractUpdateCallback(DataContext dataContext) {
        this._dataContext = dataContext;
    }

    @Override
    public TableCreationBuilder createTable(String schemaName, String tableName) throws IllegalArgumentException, IllegalStateException {
        Schema schema = this.getSchema(schemaName);
        return this.createTable(schema, tableName);
    }

    @Override
    public final TableDropBuilder dropTable(String schemaName, String tableName) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        Table table = this.getTable(schemaName, tableName);
        return this.dropTable(table);
    }

    @Override
    public final TableDropBuilder dropTable(Schema schema, String tableName) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        Table table = schema.getTableByName(tableName);
        if (table == null) {
            throw new IllegalArgumentException("Nu such table '" + tableName + "' found in schema: " + schema + ". Available tables are: " + Arrays.toString(schema.getTableNames().toArray()));
        }
        return this.dropTable(table);
    }

    @Override
    public final RowInsertionBuilder insertInto(String tableName) throws IllegalArgumentException, IllegalStateException {
        return this.insertInto(this.getTable(tableName));
    }

    @Override
    public final RowInsertionBuilder insertInto(String schemaName, String tableName) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return this.insertInto(this.getTable(schemaName, tableName));
    }

    private Table getTable(String schemaName, String tableName) {
        Schema schema = this.getSchema(schemaName);
        Table table = schema.getTableByName(tableName);
        if (table == null) {
            throw new IllegalArgumentException("Nu such table '" + tableName + "' found in schema: " + schema + ". Available tables are: " + Arrays.toString(schema.getTableNames().toArray()));
        }
        return table;
    }

    private Schema getSchema(String schemaName) {
        Schema schema = this._dataContext.getSchemaByName(schemaName);
        if (schema == null) {
            throw new IllegalArgumentException("No such schema: " + schemaName);
        }
        return schema;
    }

    @Override
    public final RowDeletionBuilder deleteFrom(String tableName) {
        return this.deleteFrom(this.getTable(tableName));
    }

    @Override
    public final RowDeletionBuilder deleteFrom(String schemaName, String tableName) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        Table table = this.getTable(schemaName, tableName);
        return this.deleteFrom(table);
    }

    @Override
    public final TableDropBuilder dropTable(String tableName) {
        return this.dropTable(this.getTable(tableName));
    }

    @Override
    public final RowUpdationBuilder update(String tableName) {
        return this.update(this.getTable(tableName));
    }

    private Table getTable(String tableName) {
        Table table = this.getDataContext().getTableByQualifiedLabel(tableName);
        if (table == null) {
            throw new IllegalArgumentException("No such table: " + tableName);
        }
        return table;
    }

    @Override
    public DataContext getDataContext() {
        return this._dataContext;
    }

    @Override
    public boolean isCreateTableSupported() {
        return true;
    }

    @Override
    public boolean isInsertSupported() {
        return true;
    }

    @Override
    public boolean isUpdateSupported() {
        return this.isInsertSupported() && this.isDeleteSupported();
    }

    @Override
    public final RowUpdationBuilder update(String schemaName, String tableName) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        Table table = this.getTable(schemaName, tableName);
        return this.update(table);
    }

    @Override
    public RowUpdationBuilder update(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new DeleteAndInsertBuilder(this, table);
    }

    public UpdateSummary getUpdateSummary() {
        return DefaultUpdateSummary.unknownUpdates();
    }
}

