/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.SchemaNameComparator;
import org.apache.metamodel.annotations.InterfaceStability;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.query.CompiledQuery;
import org.apache.metamodel.query.DefaultCompiledQuery;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.builder.InitFromBuilder;
import org.apache.metamodel.query.builder.InitFromBuilderImpl;
import org.apache.metamodel.query.parser.QueryParser;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.TableType;

@InterfaceStability.Evolving
public abstract class AbstractDataContext
implements DataContext {
    private static final String NULL_SCHEMA_NAME_TOKEN = "<metamodel.schema.name.null>";
    private final ConcurrentMap<String, Schema> _schemaCache = new ConcurrentHashMap<String, Schema>();
    private final Comparator<? super String> _schemaNameComparator = SchemaNameComparator.getInstance();
    private List<String> _schemaNameCache;

    @Override
    public final DataContext refreshSchemas() {
        this._schemaCache.clear();
        this._schemaNameCache = null;
        this.onSchemaCacheRefreshed();
        return this;
    }

    protected void onSchemaCacheRefreshed() {
    }

    @Override
    public final List<Schema> getSchemas() throws MetaModelException {
        List<String> schemaNames = this.getSchemaNames();
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        for (String name : schemaNames) {
            Schema schema = (Schema)this._schemaCache.get(this.getSchemaCacheKey(name));
            if (schema == null) {
                Schema newSchema = this.getSchemaByNameInternal(name);
                if (newSchema == null) {
                    throw new MetaModelException("Declared schema does not exist: " + name);
                }
                Schema existingSchema = this._schemaCache.putIfAbsent(this.getSchemaCacheKey(name), newSchema);
                if (existingSchema == null) {
                    schemas.add(newSchema);
                    continue;
                }
                schemas.add(existingSchema);
                continue;
            }
            schemas.add(schema);
        }
        return schemas;
    }

    private String getSchemaCacheKey(String name) {
        if (name == null) {
            return NULL_SCHEMA_NAME_TOKEN;
        }
        return name;
    }

    @Override
    public final List<String> getSchemaNames() throws MetaModelException {
        if (this._schemaNameCache == null) {
            this._schemaNameCache = this.getSchemaNamesInternal();
        }
        ArrayList<String> schemaNames = new ArrayList<String>(this._schemaNameCache);
        schemaNames.sort(this._schemaNameComparator);
        return schemaNames;
    }

    @Override
    public final Schema getDefaultSchema() throws MetaModelException {
        Schema result = null;
        String defaultSchemaName = this.getDefaultSchemaName();
        if (defaultSchemaName != null) {
            result = this.getSchemaByName(defaultSchemaName);
        }
        if (result == null) {
            List<Schema> schemas = this.getSchemas();
            if (schemas.size() == 1) {
                result = schemas.get(0);
            } else {
                int highestTableCount = -1;
                for (Schema schema : schemas) {
                    boolean isInformationSchema;
                    String name = schema.getName();
                    if (schema == null || (isInformationSchema = (name = name.toLowerCase()).startsWith("information") && name.endsWith("schema")) || schema.getTableCount() <= highestTableCount) continue;
                    highestTableCount = schema.getTableCount();
                    result = schema;
                }
            }
        }
        return result;
    }

    @Override
    public final InitFromBuilder query() {
        return new InitFromBuilderImpl(this);
    }

    @Override
    public Query parseQuery(String queryString) throws MetaModelException {
        QueryParser parser = new QueryParser(this, queryString);
        Query query = parser.parse();
        return query;
    }

    @Override
    public CompiledQuery compileQuery(Query query) throws MetaModelException {
        return new DefaultCompiledQuery(query);
    }

    @Override
    public DataSet executeQuery(CompiledQuery compiledQuery, Object ... values) {
        assert (compiledQuery instanceof DefaultCompiledQuery);
        DefaultCompiledQuery defaultCompiledQuery = (DefaultCompiledQuery)compiledQuery;
        Query query = defaultCompiledQuery.cloneWithParameterValues(values);
        return this.executeQuery(query);
    }

    @Override
    public final DataSet executeQuery(String queryString) throws MetaModelException {
        Query query = this.parseQuery(queryString);
        DataSet dataSet = this.executeQuery(query);
        return dataSet;
    }

    @Override
    public final Schema getSchemaByName(String name) throws MetaModelException {
        Schema schema = (Schema)this._schemaCache.get(this.getSchemaCacheKey(name));
        if (schema == null) {
            Schema existingSchema;
            if (name == null) {
                schema = this.getSchemaByNameInternal(null);
            } else {
                List<String> schemaNames = this.getSchemaNames();
                for (String schemaName : schemaNames) {
                    if (!name.equalsIgnoreCase(schemaName)) continue;
                    schema = this.getSchemaByNameInternal(name);
                    break;
                }
                if (schema == null) {
                    for (String schemaName : schemaNames) {
                        if (!name.equalsIgnoreCase(schemaName)) continue;
                        schema = this.getSchemaByNameInternal(schemaName);
                        break;
                    }
                }
            }
            if (schema != null && (existingSchema = this._schemaCache.putIfAbsent(this.getSchemaCacheKey(schema.getName()), schema)) != null) {
                return existingSchema;
            }
        }
        return schema;
    }

    @Override
    public final Column getColumnByQualifiedLabel(String columnName) {
        Column column;
        Object column2;
        Table table;
        Schema schema;
        if (columnName == null) {
            return null;
        }
        String[] tokens = this.tokenizePath(columnName, 3);
        if (tokens != null && (schema = this.getSchemaByToken(tokens[0])) != null && (table = schema.getTableByName(tokens[1])) != null && (column2 = table.getColumnByName(tokens[2])) != null) {
            return column2;
        }
        schema = null;
        List<String> schemaNames = this.getSchemaNames();
        for (String string : schemaNames) {
            if (string == null) {
                Column column3;
                schema = this.getSchemaByName(null);
                if (schema == null || (column3 = this.getColumn(schema, columnName)) == null) continue;
                return column3;
            }
            Column col = this.searchColumn(string, columnName, columnName);
            if (col == null) continue;
            return col;
        }
        String columnNameInLowerCase = columnName.toLowerCase();
        for (String schemaName : schemaNames) {
            String schemaNameInLowerCase;
            Column col;
            if (schemaName == null || (col = this.searchColumn(schemaNameInLowerCase = schemaName.toLowerCase(), columnName, columnNameInLowerCase)) == null) continue;
            return col;
        }
        schema = this.getDefaultSchema();
        if (schema != null && (column = this.getColumn(schema, columnName)) != null) {
            return column;
        }
        return null;
    }

    private Column searchColumn(String schemaNameSearch, String columnNameOriginal, String columnNameSearch) {
        Schema schema = this.getSchemaByName(schemaNameSearch);
        if (schema != null) {
            String tableAndColumnPath;
            if (columnNameSearch.equals(schemaNameSearch)) {
                return this.getColumn(schema, columnNameSearch);
            }
            if (columnNameSearch.startsWith(schemaNameSearch) && (tableAndColumnPath = columnNameOriginal.substring(schemaNameSearch.length())).charAt(0) == '.') {
                tableAndColumnPath = tableAndColumnPath.substring(1);
                return this.getColumn(schema, tableAndColumnPath);
            }
        }
        return null;
    }

    private Column getColumn(Schema schema, String tableAndColumnPath) {
        Column column;
        Table table = null;
        String columnPath = tableAndColumnPath;
        List<String> tableNames = schema.getTableNames();
        for (String tableName : tableNames) {
            if (tableName == null || !this.isStartingToken(tableName, tableAndColumnPath)) continue;
            table = schema.getTableByName(tableName);
            columnPath = tableAndColumnPath.substring(tableName.length());
            if (columnPath.charAt(0) != '.') continue;
            columnPath = columnPath.substring(1);
            break;
        }
        if (table == null) {
            String tableAndColumnPathInLowerCase = tableAndColumnPath.toLowerCase();
            for (String tableName : tableNames) {
                String tableNameInLowerCase;
                if (tableName == null || !this.isStartingToken(tableNameInLowerCase = tableName.toLowerCase(), tableAndColumnPathInLowerCase)) continue;
                table = schema.getTableByName(tableName);
                columnPath = tableAndColumnPath.substring(tableName.length());
                if (columnPath.charAt(0) != '.') continue;
                columnPath = columnPath.substring(1);
                break;
            }
        }
        if (table == null && schema.getTables().stream().filter(t -> t.getType() != TableType.ALIAS).count() == 1L) {
            table = schema.getTables().get(0);
        }
        if (table != null && (column = table.getColumnByName(columnPath)) != null) {
            return column;
        }
        return null;
    }

    @Override
    public final Table getTableByQualifiedLabel(String tableName) {
        Table table;
        Schema schema;
        if (tableName == null) {
            return null;
        }
        String[] tokens = this.tokenizePath(tableName, 2);
        if (tokens != null && (schema = this.getSchemaByToken(tokens[0])) != null && (table = schema.getTableByName(tokens[1])) != null) {
            return table;
        }
        schema = null;
        List<String> schemaNames = this.getSchemaNames();
        for (String string : schemaNames) {
            if (string == null) {
                schema = this.getSchemaByName(null);
                if (schema == null) continue;
                Table table2 = schema.getTableByName(tableName);
                return table2;
            }
            if (!this.isStartingToken(string, tableName)) continue;
            schema = this.getSchemaByName(string);
        }
        if (schema == null) {
            String tableNameInLowerCase = tableName.toLowerCase();
            for (String schemaName3 : schemaNames) {
                String schemaNameInLowerCase;
                if (schemaName3 == null || !this.isStartingToken(schemaNameInLowerCase = schemaName3.toLowerCase(), tableNameInLowerCase)) continue;
                schema = this.getSchemaByName(schemaName3);
            }
        }
        if (schema == null) {
            schema = this.getDefaultSchema();
        }
        String tablePart = tableName.toLowerCase();
        String string = schema.getName();
        if (string != null && this.isStartingToken(string.toLowerCase(), tablePart) && (tablePart = tablePart.substring(string.length())).startsWith(".")) {
            tablePart = tablePart.substring(1);
        }
        return schema.getTableByName(tablePart);
    }

    private String[] tokenizePath(String path, int expectedParts) {
        ArrayList<String> tokens = new ArrayList<String>(expectedParts);
        boolean inQuotes = false;
        StringBuilder currentToken = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '.' && !inQuotes) {
                tokens.add(currentToken.toString());
                currentToken.setLength(0);
                if (tokens.size() <= expectedParts) continue;
                return null;
            }
            if (c == '\"') {
                if (inQuotes ? i + 1 < path.length() && path.charAt(i + 1) != '.' : currentToken.length() > 0) {
                    return null;
                }
                inQuotes = !inQuotes;
                continue;
            }
            currentToken.append(c);
        }
        if (currentToken.length() > 0) {
            tokens.add(currentToken.toString());
        }
        if (tokens.size() == expectedParts - 1) {
            tokens.add(0, null);
        } else if (tokens.size() != expectedParts) {
            return null;
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private Schema getSchemaByToken(String token) {
        if (token == null) {
            return this.getDefaultSchema();
        }
        try {
            return this.getSchemaByName(token);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private boolean isStartingToken(String partName, String fullName) {
        if (fullName.startsWith(partName)) {
            char nextChar;
            int length = partName.length();
            if (length == 0) {
                return false;
            }
            if (fullName.length() > length && this.isQualifiedPathDelim(nextChar = fullName.charAt(length))) {
                return true;
            }
        }
        return false;
    }

    protected boolean isQualifiedPathDelim(char c) {
        return c == '.' || c == '\"';
    }

    protected abstract List<String> getSchemaNamesInternal();

    protected abstract String getDefaultSchemaName();

    protected abstract Schema getSchemaByNameInternal(String var1);
}

